/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.data;

import java.util.EnumMap;
import java.util.Map;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.util.EnumUtils;
import net.minecraft.core.Direction;

public sealed class TransmitterModelData {
    private final Map<Direction, ConnectionType> connections = new EnumMap<Direction, ConnectionType>(Direction.class);
    private boolean hasColor;

    public void setConnectionData(Direction direction, ConnectionType connectionType) {
        this.connections.put(direction, connectionType);
    }

    public Map<Direction, ConnectionType> getConnectionsMap() {
        return this.connections;
    }

    public ConnectionType getConnectionType(Direction side) {
        return this.connections.get(side);
    }

    public void setHasColor(boolean hasColor) {
        this.hasColor = hasColor;
    }

    public boolean getHasColor() {
        return this.hasColor;
    }

    public boolean check(ConnectionType ... types) {
        if (types.length != EnumUtils.DIRECTIONS.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (this.connections.get(EnumUtils.DIRECTIONS[i]) == types[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransmitterModelData)) return false;
        TransmitterModelData other = (TransmitterModelData)o;
        if (this.hasColor != other.hasColor) return false;
        if (!this.connections.equals(other.connections)) return false;
        return true;
    }

    public int hashCode() {
        int result = this.connections.hashCode();
        result = 31 * result + Boolean.hashCode(this.hasColor);
        return result;
    }

    public static final class Diversion
    extends TransmitterModelData {
        @Override
        public void setHasColor(boolean hasColor) {
        }
    }
}

