/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.data;

import java.util.List;
import java.util.Map;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class DataBasedBakedModel
extends BakedModelWrapper<BakedModel> {
    private final Map<ModelProperty<Void>, BakedModel> propertyBased;

    DataBasedBakedModel(BakedModel baseModel, Map<ModelProperty<Void>, BakedModel> propertyBased) {
        super(baseModel);
        this.propertyBased = propertyBased;
    }

    private BakedModel getModelForData(ModelData data) {
        if (data.getProperties().isEmpty()) {
            return this.originalModel;
        }
        for (Map.Entry<ModelProperty<Void>, BakedModel> entry : this.propertyBased.entrySet()) {
            if (!data.has(entry.getKey())) continue;
            return entry.getValue();
        }
        return this.originalModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        return this.getModelForData(extraData).getQuads(state, side, rand, extraData, renderType);
    }

    public TriState useAmbientOcclusion(BlockState state, ModelData data, RenderType renderType) {
        return this.getModelForData(data).useAmbientOcclusion(state, data, renderType);
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        return this.getModelForData(modelData).getModelData(level, pos, state, modelData);
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        return this.getModelForData(data).getParticleIcon(data);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return this.getModelForData(data).getRenderTypes(state, rand, data);
    }
}

