/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom.module;

import mekanism.api.gear.config.ModuleBooleanConfig;
import mekanism.client.gui.element.button.RadioButton;
import mekanism.client.gui.element.custom.module.GuiModuleScreen;
import mekanism.client.gui.element.custom.module.MiniElement;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;

class BooleanToggle
extends MiniElement<Boolean> {
    private static final int RADIO_SIZE = 8;

    BooleanToggle(GuiModuleScreen parent, ModuleBooleanConfig data, Component description, int xPos, int yPos) {
        super(parent, data, description, xPos, yPos);
    }

    @Override
    protected int getNeededHeight() {
        return 20;
    }

    @Override
    protected void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawRadio(guiGraphics, mouseX, mouseY, (Boolean)this.data.get(), 4, 11, 0);
        this.drawRadio(guiGraphics, mouseX, mouseY, (Boolean)this.data.get() == false, 50, 11, 8);
    }

    private void drawRadio(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean selected, int relativeX, int relativeY, int selectedU) {
        if (selected) {
            guiGraphics.blit(RadioButton.RADIO, this.getRelativeX() + relativeX, this.getRelativeY() + relativeY, (float)selectedU, 8.0f, 8, 8, 16, 16);
        } else {
            boolean hovered = this.mouseOver(mouseX, mouseY, relativeX, relativeY, 8, 8);
            guiGraphics.blit(RadioButton.RADIO, this.getRelativeX() + relativeX, this.getRelativeY() + relativeY, hovered ? 8.0f : 0.0f, 0.0f, 8, 8, 16, 16);
        }
    }

    @Override
    protected void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int textColor = this.parent.screenTextColor();
        this.parent.drawScaledScrollingString(guiGraphics, this.description, this.xPos, this.yPos, IFancyFontRenderer.TextAlignment.LEFT, textColor, this.parent.getScreenWidth() - 6, 2, false, 0.8f);
        int trueShift = 12;
        int falseShift = 58;
        this.parent.drawScaledScrollingString(guiGraphics, (Component)MekanismLang.TRUE.translate(), this.xPos + trueShift, this.yPos + 11, IFancyFontRenderer.TextAlignment.LEFT, textColor, 50 - trueShift, 3, false, 0.8f);
        this.parent.drawScaledScrollingString(guiGraphics, (Component)MekanismLang.FALSE.translate(), this.xPos + falseShift, this.yPos + 11, IFancyFontRenderer.TextAlignment.LEFT, textColor, this.parent.getScreenWidth() - 6 - falseShift, 3, false, 0.8f);
    }

    @Override
    protected void click(double mouseX, double mouseY) {
        if (((Boolean)this.data.get()).booleanValue()) {
            if (this.mouseOver(mouseX, mouseY, 50, 11, 8, 8)) {
                this.setDataFromClick(false);
            }
        } else if (this.mouseOver(mouseX, mouseY, 4, 11, 8, 8)) {
            this.setDataFromClick(true);
        }
    }

    private void setDataFromClick(boolean value) {
        this.setData(value);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)(value ? (SoundEvent)MekanismSounds.BEEP_ON.get() : (SoundEvent)MekanismSounds.BEEP_OFF.get()), (float)1.0f, (float)1.0f));
    }
}

