/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.event.ScytheHarvestCropEvent;
import com.blakebr0.cucumber.helper.CropHelper;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BaseScytheItem
extends SwordItem {
    private final float attackDamage;
    private final float attackSpeed;
    private final int range;

    public BaseScytheItem(Tier tier, int range) {
        this(tier, range, p -> p);
    }

    public BaseScytheItem(Tier tier, int range, Function<Item.Properties, Item.Properties> properties) {
        super(tier, properties.apply(new Item.Properties().attributes(BaseScytheItem.createAttributes((Tier)tier, (int)4, (float)-2.8f))));
        this.attackDamage = 4.0f;
        this.attackSpeed = -2.8f;
        this.range = range;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        Direction face = context.getClickedFace();
        ItemStack stack = player.getItemInHand(hand);
        if (!player.mayUseItemAt(pos.relative(face), face, stack)) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        AtomicBoolean harvested = new AtomicBoolean();
        BlockPos.betweenClosed((BlockPos)pos.offset(-this.range, 0, -this.range), (BlockPos)pos.offset(this.range, 0, this.range)).forEach(aoePos -> {
            if (stack.isEmpty()) {
                return;
            }
            BlockState state = level.getBlockState(aoePos);
            Block block = state.getBlock();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                Item seed = CropHelper.getSeedsItem((Block)crop);
                if (crop.isMaxAge(state) && seed != null) {
                    BaseScytheItem.harvest(player, level, aoePos.immutable(), state, crop.getStateForAge(0), seed, stack, harvested);
                }
            }
            if (block instanceof NetherWartBlock && (Integer)state.getValue((Property)NetherWartBlock.AGE) == 3) {
                BaseScytheItem.harvest(player, level, aoePos.immutable(), state, (BlockState)state.setValue((Property)NetherWartBlock.AGE, (Comparable)Integer.valueOf(0)), Items.NETHER_WART, stack, harvested);
            }
        });
        if (harvested.get()) {
            level.playSound(null, pos, SoundEvents.CROP_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player.getAttackStrengthScale(0.5f) >= 0.95f) {
            Level level = player.level();
            double range = this.range >= 2 ? 1.0 + (double)(this.range - 1) * 0.25 : 1.0;
            List entities = level.getEntitiesOfClass(LivingEntity.class, entity.getBoundingBox().inflate(range, 0.25, range));
            Optional<Optional> damageType = level.registryAccess().lookup(Registries.DAMAGE_TYPE).map(r -> r.get(DamageTypes.PLAYER_ATTACK));
            for (LivingEntity aoeEntity : entities) {
                float attackDamage;
                DamageSource source;
                float damage;
                if (aoeEntity == player || aoeEntity == entity || player.isAlliedTo(entity) || !damageType.isPresent() || !damageType.get().isPresent() || !((damage = CommonHooks.onLivingDamagePre((LivingEntity)aoeEntity, (DamageContainer)new DamageContainer(source = new DamageSource((Holder)damageType.get().get(), (Entity)player), attackDamage = this.getAttackDamage() * 0.67f))) > 0.0f)) continue;
                aoeEntity.knockback((double)0.4f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                aoeEntity.hurt(source, damage);
                CommonHooks.onLivingDamagePost((LivingEntity)aoeEntity, (DamageContainer)new DamageContainer(source, damage));
            }
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, player.getSoundSource(), 1.0f, 1.0f);
            player.sweepAttack();
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public float getAttackDamage() {
        return this.attackDamage + this.getTier().getAttackDamageBonus();
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    private static void harvest(Player player, Level level, BlockPos pos, BlockState state, BlockState newState, Item item, ItemStack stack, AtomicBoolean harvested) {
        if (((ScytheHarvestCropEvent)NeoForge.EVENT_BUS.post((Event)new ScytheHarvestCropEvent((LevelAccessor)level, pos, state, stack, player))).isCanceled()) {
            return;
        }
        if (((BlockEvent.BreakEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, state, player))).isCanceled()) {
            return;
        }
        BaseScytheItem.handleDrops(state, level, pos, (ItemLike)item);
        stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        level.setBlockAndUpdate(pos, newState);
        harvested.set(true);
    }

    private static void handleDrops(BlockState state, Level level, BlockPos pos, ItemLike seed) {
        List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos));
        for (ItemStack drop : drops) {
            Item item = drop.getItem();
            if (drop.isEmpty() || item != seed) continue;
            drop.shrink(1);
            break;
        }
        for (ItemStack drop : drops) {
            if (drop.isEmpty()) continue;
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
        }
    }
}

