/*
 * Decompiled with CFR 0.152.
 */
package dev.denismasterherobrine.haydenapi.configuration;

import dev.denismasterherobrine.haydenapi.configuration.annotation.Config;
import dev.denismasterherobrine.haydenapi.configuration.annotation.Entry;
import dev.denismasterherobrine.haydenapi.configuration.annotation.Reloadable;
import dev.denismasterherobrine.haydenapi.configuration.exception.ConfigurationException;
import dev.denismasterherobrine.haydenapi.configuration.format.FormatHandler;
import dev.denismasterherobrine.haydenapi.configuration.format.Json5ConfigurationHandler;
import dev.denismasterherobrine.haydenapi.configuration.format.TomlConfigurationHandler;
import dev.denismasterherobrine.haydenapi.configuration.format.YamlConfigurationHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationManager {
    private final Map<String, FormatHandler> formatHandlerMap = new HashMap<String, FormatHandler>();

    public ConfigurationManager() {
        this.formatHandlerMap.put("json5", new Json5ConfigurationHandler());
        this.formatHandlerMap.put("toml", new TomlConfigurationHandler());
        this.formatHandlerMap.put("yaml", new YamlConfigurationHandler());
    }

    private String getFormatFromFile(File file) {
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return "json5";
        }
        return name.substring(dotIndex + 1).toLowerCase();
    }

    public <T> T initializeConfig(String filename, Class<T> configClass) throws ConfigurationException {
        T config;
        if (!configClass.isAnnotationPresent(Config.class)) {
            throw new ConfigurationException("Class " + configClass.getName() + " was not annotated with @Config!");
        }
        File file = new File(filename);
        if (!file.exists()) {
            config = this.createNewConfig(configClass);
            this.saveConfig(file, config);
        } else {
            config = this.loadConfig(file, configClass);
        }
        if (this.hasReloadableFields(configClass)) {
            this.startFileWatcher(file, config, configClass);
        }
        return config;
    }

    public <T> T createNewConfig(Class<T> configClass) throws ConfigurationException {
        try {
            return configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ConfigurationException("Error creating instance of configuration file for class: " + configClass.getName(), e);
        }
    }

    public <T> T loadConfig(File file, Class<T> configClass) throws ConfigurationException {
        String format = this.getFormatFromFile(file);
        FormatHandler handler = this.formatHandlerMap.get(format);
        if (handler == null) {
            throw new ConfigurationException("Unsupported file format: " + format);
        }
        return handler.load(file, configClass);
    }

    public <T> void saveConfig(File file, T config) throws ConfigurationException {
        String format = this.getFormatFromFile(file);
        FormatHandler handler = this.formatHandlerMap.get(format);
        if (handler == null) {
            throw new ConfigurationException("Unsupported file format: " + format);
        }
        handler.save(file, config);
    }

    private <T> boolean hasReloadableFields(Class<T> configClass) {
        for (Field field : configClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Entry.class) || !field.isAnnotationPresent(Reloadable.class)) continue;
            return true;
        }
        return false;
    }

    private <T> void startFileWatcher(File file, T config, Class<T> configClass) {
        Path dir = file.toPath().getParent();
        if (dir == null) {
            return;
        }
        Thread watcherThread = new Thread(() -> {
            try {
                WatchService watchService = FileSystems.getDefault().newWatchService();
                dir.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                while (true) {
                    WatchKey key = watchService.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path changed;
                        if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !(changed = (Path)event.context()).toString().equals(file.getName())) continue;
                        Object newConfig = this.loadConfig(file, configClass);
                        this.updateReloadableFields(config, newConfig, configClass);
                    }
                    key.reset();
                }
            }
            catch (Exception e) {
                System.err.println("Error watching configuration file: " + e.getMessage());
                return;
            }
        });
        watcherThread.setDaemon(true);
        watcherThread.start();
    }

    private <T> void updateReloadableFields(T original, T updated, Class<T> configClass) {
        Field[] fields;
        for (Field field : fields = configClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Entry.class) || !field.isAnnotationPresent(Reloadable.class)) continue;
            try {
                field.setAccessible(true);
                Object newValue = field.get(updated);
                field.set(original, newValue);
                System.out.println("Field " + field.getName() + " updated to value: " + String.valueOf(newValue));
            }
            catch (IllegalAccessException e) {
                System.err.println("Error updating field " + field.getName() + ": " + e.getMessage());
            }
        }
    }
}

