/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.rangedpumps.block;

import com.refinedmods.rangedpumps.blockentity.PumpBlockEntity;
import com.refinedmods.rangedpumps.blockentity.PumpState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class PumpBlock
extends Block
implements EntityBlock {
    public PumpBlock() {
        super(BlockBehaviour.Properties.of().strength(1.9f).sound(SoundType.STONE));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof PumpBlockEntity) {
            PumpBlockEntity pump = (PumpBlockEntity)blockEntity;
            IEnergyStorage energy = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, pos, (Object)Direction.NORTH);
            if (energy == null) {
                return InteractionResult.SUCCESS;
            }
            Component message = PumpState.getMessage(pump);
            if (message != null) {
                player.sendSystemMessage(message);
            }
            if (pump.getTank().getFluidAmount() == 0) {
                player.sendSystemMessage((Component)Component.translatable((String)"block.rangedpumps.pump.state_empty", (Object[])new Object[]{energy.getEnergyStored(), energy.getMaxEnergyStored()}));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"block.rangedpumps.pump.state", (Object[])new Object[]{pump.getTank().getFluidAmount(), pump.getTank().getFluid().getHoverName(), energy.getEnergyStored(), energy.getMaxEnergyStored()}));
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PumpBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide ? (levelTicker, pos, stateTicker, blockEntity) -> ((PumpBlockEntity)blockEntity).tick() : null;
    }
}

