/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl.utils.serializer.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.Tag;
import net.sixik.sdmcore.impl.utils.serializer.SDMSerializerHelper;
import net.sixik.sdmcore.impl.utils.serializer.data.IData;

public class MapData<K extends IData, V extends IData>
implements IData {
    public Map<K, V> dataMap = new HashMap();

    public MapData() {
    }

    public MapData(Map<K, V> dataMap) {
        this.dataMap = dataMap;
    }

    public MapData<K, V> putValue(K key, V value) {
        this.dataMap.put(key, value);
        return this;
    }

    public MapData<K, V> putValue(K key, Tag value) {
        this.dataMap.put(key, SDMSerializerHelper.NBTToData(value));
        return this;
    }

    public V get(K key) {
        return (V)((IData)this.dataMap.get(key));
    }

    @Override
    public byte getID() {
        return 3;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.getID());
        dataOutput.writeInt(this.dataMap.size());
        for (Map.Entry<K, V> kvEntry : this.dataMap.entrySet()) {
            ((IData)kvEntry.getKey()).write(dataOutput);
            ((IData)kvEntry.getValue()).write(dataOutput);
        }
    }

    @Override
    public void read(DataInput input) throws IOException {
        int size = input.readInt();
        HashMap<IData, IData> map = new HashMap<IData, IData>(size);
        for (int i = 0; i < size; ++i) {
            IData key = IData.createByByte(input.readByte());
            if (key == null) continue;
            key.read(input);
            IData value = IData.createByByte(input.readByte());
            if (value == null) continue;
            value.read(input);
            map.put(key, value);
        }
        this.dataMap = map;
    }

    public String toString() {
        return "MapData{dataMap=" + String.valueOf(this.dataMap) + "}";
    }
}

