/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl.utils.serializer.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.Tag;
import net.sixik.sdmcore.impl.utils.serializer.SDMSerializerHelper;
import net.sixik.sdmcore.impl.utils.serializer.data.IData;

public class ListData<T extends IData>
implements IData {
    public List<T> data = new ArrayList<T>();

    public ListData() {
    }

    public ListData(List<T> data) {
        this.data = data;
    }

    public ListData<T> addValue(T v) {
        this.data.add(v);
        return this;
    }

    public ListData<T> addValue(Tag v) {
        this.data.add(SDMSerializerHelper.NBTToData(v));
        return this;
    }

    @Override
    public byte getID() {
        return 1;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.getID());
        dataOutput.writeInt(this.data.size());
        for (IData datum : this.data) {
            datum.write(dataOutput);
        }
    }

    @Override
    public void read(DataInput input) throws IOException {
        int size = input.readInt();
        ArrayList<T> tList = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            IData v = IData.createByByte(input.readByte());
            if (v == null) continue;
            v.read(input);
            tList.add(v);
        }
        this.data = tList;
    }

    public String toString() {
        return "ListData{data=" + String.valueOf(this.data) + "}";
    }
}

