/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl.utils.serializer.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.Tag;
import net.sixik.sdmcore.impl.utils.serializer.SDMSerializerHelper;
import net.sixik.sdmcore.impl.utils.serializer.data.IData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.BoolData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.ByteData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.CharData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.DoubleData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.FloatData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.IntData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.LongData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.ShortData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.StringData;

public class KeyData
implements IData {
    public Map<String, IData> DATA = new HashMap<String, IData>();

    public boolean isEmpty() {
        return this.DATA.isEmpty();
    }

    public KeyData put(String key, IData data) {
        this.DATA.put(key, data);
        return this;
    }

    public KeyData put(String key, String data) {
        this.DATA.put(key, new StringData(data));
        return this;
    }

    public KeyData put(String key, short data) {
        this.DATA.put(key, new ShortData(data));
        return this;
    }

    public KeyData put(String key, int data) {
        this.DATA.put(key, new IntData(data));
        return this;
    }

    public KeyData put(String key, float data) {
        this.DATA.put(key, new FloatData(data));
        return this;
    }

    public KeyData put(String key, double data) {
        this.DATA.put(key, new DoubleData(data));
        return this;
    }

    public KeyData put(String key, long data) {
        this.DATA.put(key, new LongData(data));
        return this;
    }

    public KeyData put(String key, char data) {
        this.DATA.put(key, new CharData(data));
        return this;
    }

    public KeyData put(String key, boolean data) {
        this.DATA.put(key, new BoolData(data));
        return this;
    }

    public KeyData put(String key, byte data) {
        this.DATA.put(key, new ByteData(data));
        return this;
    }

    public KeyData put(String key, Tag data) {
        this.put(key, SDMSerializerHelper.NBTToData(data));
        return this;
    }

    public IData getData(String key) {
        return this.DATA.get(key);
    }

    public boolean contains(String key) {
        return this.DATA.containsKey(key);
    }

    @Override
    public byte getID() {
        return 10;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeByte(this.getID());
        dataOutput.writeInt(this.DATA.size());
        for (Map.Entry<String, IData> kvEntry : this.DATA.entrySet()) {
            dataOutput.writeUTF(kvEntry.getKey());
            kvEntry.getValue().write(dataOutput);
        }
    }

    @Override
    public void read(DataInput input) throws IOException {
        int size = input.readInt();
        HashMap<String, IData> map = new HashMap<String, IData>(size);
        for (int i = 0; i < size; ++i) {
            String key = input.readUTF();
            IData value = IData.createByByte(input.readByte());
            if (value == null) continue;
            value.read(input);
            map.put(key, value);
        }
        this.DATA = map;
    }

    public String toString() {
        return "KeyData{DATA=" + String.valueOf(this.DATA) + "}";
    }
}

