/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl.utils.serializer.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.Tag;
import net.sixik.sdmcore.impl.utils.serializer.SDMSerializerHelper;
import net.sixik.sdmcore.impl.utils.serializer.data.KeyData;
import net.sixik.sdmcore.impl.utils.serializer.data.ListData;
import net.sixik.sdmcore.impl.utils.serializer.data.MapData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.BoolData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.ByteData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.CharData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.DoubleData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.FloatData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.IntData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.LongData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.ShortData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.StringData;

public interface IData {
    public static final byte DATA_STRING = 0;
    public static final byte DATA_INT = 2;
    public static final byte DATA_LONG = 4;
    public static final byte DATA_BYTE = 5;
    public static final byte DATA_CHAR = 6;
    public static final byte DATA_DOUBLE = 7;
    public static final byte DATA_FLOAT = 8;
    public static final byte DATA_BOOLEAN = 9;
    public static final byte DATA_LIST = 1;
    public static final byte DATA_MAP = 3;
    public static final byte DATA_KEY = 10;
    public static final byte DATA_SHORT = 11;

    public byte getID();

    public void write(DataOutput var1) throws IOException;

    public void read(DataInput var1) throws IOException;

    default public ListData<IData> asList() {
        return (ListData)this;
    }

    default public MapData<IData, IData> asMap() {
        return (MapData)this;
    }

    default public KeyData asKeyMap() {
        return (KeyData)this;
    }

    default public String asString() {
        return ((StringData)this).value;
    }

    default public long asLong() {
        return ((LongData)this).l;
    }

    default public int asInt() {
        return ((IntData)this).value;
    }

    default public byte asByte() {
        return ((ByteData)this).b;
    }

    default public char asChar() {
        return ((CharData)this).c;
    }

    default public double asDouble() {
        return ((DoubleData)this).d;
    }

    default public float asFloat() {
        return ((FloatData)this).f;
    }

    default public boolean asBool() {
        return ((BoolData)this).v;
    }

    default public short asShort() {
        return ((ShortData)this).aShort;
    }

    default public Tag asNBT() {
        return SDMSerializerHelper.dataToNBT(this);
    }

    public static IData valueOf(String v) {
        return new StringData(v);
    }

    public static IData valueOf(long v) {
        return new LongData(v);
    }

    public static IData valueOf(int v) {
        return new IntData(v);
    }

    public static IData valueOf(byte v) {
        return new ByteData(v);
    }

    public static IData valueOf(char v) {
        return new CharData(v);
    }

    public static IData valueOf(double v) {
        return new DoubleData(v);
    }

    public static IData valueOf(float v) {
        return new FloatData(v);
    }

    public static IData valueOf(short v) {
        return new ShortData(v);
    }

    public static IData valueOf(boolean v) {
        return new BoolData(v);
    }

    public static IData valueOf(Tag nbt) {
        return SDMSerializerHelper.NBTToData(nbt);
    }

    public static IData createByByte(byte b) {
        if (b == 0) {
            return new StringData("");
        }
        if (b == 2) {
            return new IntData();
        }
        if (b == 4) {
            return new LongData();
        }
        if (b == 5) {
            return new ByteData();
        }
        if (b == 6) {
            return new CharData();
        }
        if (b == 7) {
            return new DoubleData();
        }
        if (b == 8) {
            return new FloatData();
        }
        if (b == 9) {
            return new BoolData();
        }
        if (b == 1) {
            return new ListData();
        }
        if (b == 3) {
            return new MapData();
        }
        if (b == 10) {
            return new KeyData();
        }
        return null;
    }
}

