/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl.utils.serializer;

import com.mojang.serialization.DynamicOps;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmcore.SDMCore;
import net.sixik.sdmcore.impl.mixin.nbt.CompoundTagAccessor;
import net.sixik.sdmcore.impl.utils.serializer.data.IData;
import net.sixik.sdmcore.impl.utils.serializer.data.KeyData;
import net.sixik.sdmcore.impl.utils.serializer.data.ListData;
import net.sixik.sdmcore.impl.utils.serializer.data.MapData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.BoolData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.ByteData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.CharData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.DoubleData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.FloatData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.IntData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.LongData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.ShortData;
import net.sixik.sdmcore.impl.utils.serializer.data.basic.StringData;
import org.jetbrains.annotations.Nullable;

public class SDMSerializerHelper {
    public static IData serializeType(Object object) {
        KeyData data = new KeyData();
        if (object instanceof Integer) {
            Integer integer = (Integer)object;
            data.put("i_value", integer);
        } else if (object instanceof Double) {
            Double d = (Double)object;
            data.put("d_value", d);
        } else if (object instanceof Float) {
            Float f = (Float)object;
            data.put("f_value", f.floatValue());
        } else if (object instanceof Long) {
            Long l = (Long)object;
            data.put("l_value", l);
        } else if (object instanceof String) {
            String s = (String)object;
            data.put("str_value", s);
        } else if (object instanceof Boolean) {
            Boolean b = (Boolean)object;
            data.put("b_value", b);
        } else if (object instanceof Character) {
            Character c = (Character)object;
            data.put("c_value", c.charValue());
        } else if (object instanceof Short) {
            Short sh = (Short)object;
            data.put("sh_value", sh);
        } else if (object instanceof Byte) {
            Byte by = (Byte)object;
            data.put("by_value", by);
        } else if (object instanceof BlockPos) {
            BlockPos pos = (BlockPos)object;
            data.put("x_blockpos_value", pos.getX());
            data.put("y_blockpos_value", pos.getY());
            data.put("z_blockpos_value", pos.getZ());
        } else if (object instanceof Vec3i) {
            Vec3i pos = (Vec3i)object;
            data.put("x_vec3i_value", pos.getX());
            data.put("y_vec3i_value", pos.getY());
            data.put("z_vec3i_value", pos.getZ());
        } else {
            Class<?> cls = object.getClass();
            MapData<StringData, IData> fieldsData = new MapData<StringData, IData>();
            for (Field field : cls.getDeclaredFields()) {
                field.setAccessible(true);
                try {
                    Object value = field.get(object);
                    if (value == null) continue;
                    fieldsData.putValue(new StringData(field.getName()), SDMSerializerHelper.serializeType(value));
                }
                catch (IllegalAccessException e) {
                    SDMCore.SDMLOGGER.addError(e);
                }
            }
            data.put("o_value", object.getClass().getName());
            data.put("o_value_param", fieldsData);
        }
        return data;
    }

    public static Object deserializeType(KeyData data) {
        if (data.contains("i_value")) {
            return data.getData("i_value").asInt();
        }
        if (data.contains("d_value")) {
            return data.getData("d_value").asDouble();
        }
        if (data.contains("f_value")) {
            return Float.valueOf(data.getData("f_value").asFloat());
        }
        if (data.contains("l_value")) {
            return data.getData("l_value").asLong();
        }
        if (data.contains("str_value")) {
            return data.getData("str_value").asString();
        }
        if (data.contains("b_value")) {
            return data.getData("b_value").asBool();
        }
        if (data.contains("c_value")) {
            return Character.valueOf(data.getData("c_value").asChar());
        }
        if (data.contains("sh_value")) {
            return data.getData("sh_value").asShort();
        }
        if (data.contains("by_value")) {
            return data.getData("by_value").asByte();
        }
        if (data.contains("x_blockpos_value")) {
            return new BlockPos(data.getData("x_blockpos_value").asInt(), data.getData("y_blockpos_value").asInt(), data.getData("z_blockpos_value").asInt());
        }
        if (data.contains("x_vec3i_value")) {
            return new BlockPos(data.getData("x_vec3i_value").asInt(), data.getData("y_vec3i_value").asInt(), data.getData("z_vec3i_value").asInt());
        }
        throw new IllegalArgumentException("Unsupported key in data: " + String.valueOf(data));
    }

    public static Class<?> deserializeJavaClass(String className) {
        Class<?> cls;
        block8: {
            cls = null;
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                if (className.equals("boolean")) {
                    return Boolean.TYPE;
                }
                if (className.equals("char")) {
                    return Character.TYPE;
                }
                if (className.equals("int")) {
                    return Integer.TYPE;
                }
                if (className.equals("double")) {
                    return Double.TYPE;
                }
                if (className.equals("float")) {
                    return Float.TYPE;
                }
                if (className.equals("long")) {
                    return Long.TYPE;
                }
                if (!className.equals("byte")) break block8;
                return Byte.TYPE;
            }
        }
        return cls;
    }

    @Nullable
    public static Class<?> deserializeClass(KeyData data, String key) {
        if (!data.contains(key)) {
            return null;
        }
        return SDMSerializerHelper.deserializeJavaClass(data.getData(key).asString());
    }

    public static void serializeJavaClass(KeyData data, String key, Class<?> javaClass) {
        data.put(key, javaClass.getName());
    }

    public static void serializeItem(KeyData data, String key, Item item, HolderLookup.Provider provider) {
        SDMSerializerHelper.serializeItemStack(data, key, item.getDefaultInstance(), provider);
    }

    public static void serializeItemStack(KeyData data, String key, ItemStack itemStack, HolderLookup.Provider provider) {
        KeyData itemData = new KeyData();
        try {
            CompoundTag itemTag = (CompoundTag)itemStack.save(provider);
            for (Map.Entry<String, Tag> arrayData : ((CompoundTagAccessor)itemTag).getTags().entrySet()) {
                itemData.put(arrayData.getKey(), arrayData.getValue());
            }
        }
        catch (Exception e) {
            itemData.put("id", "minecraft:air");
        }
        itemData.put("count", itemStack.getCount());
        data.put(key, itemData);
    }

    public static ItemStack deserializeItemStack(KeyData data, String key, HolderLookup.Provider provider) {
        Tag tag = SDMSerializerHelper.dataToNBT(data.getData(key));
        if (tag == null || ((CompoundTag)tag).isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ItemStack.SINGLE_ITEM_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().orElse(ItemStack.EMPTY);
        stack.setCount(data.getData(key).asKeyMap().getData("count").asInt());
        return stack;
    }

    public static Tag dataToNBT(IData mainData) {
        CompoundTag compoundTag = new CompoundTag();
        if (mainData instanceof KeyData) {
            KeyData data = (KeyData)mainData;
            for (Map.Entry<String, IData> stringIDataEntry : data.DATA.entrySet()) {
                compoundTag.put(stringIDataEntry.getKey(), SDMSerializerHelper.dataToNBT(stringIDataEntry.getValue()));
            }
            return compoundTag;
        }
        if (mainData instanceof ListData) {
            ListData data = (ListData)mainData;
            ListTag listTag = new ListTag();
            for (IData datum : data.data) {
                listTag.add((Object)SDMSerializerHelper.dataToNBT(datum));
            }
            return listTag;
        }
        if (mainData instanceof StringData) {
            StringData data = (StringData)mainData;
            return StringTag.valueOf((String)data.value);
        }
        if (mainData instanceof BoolData) {
            BoolData data = (BoolData)mainData;
            return ByteTag.valueOf((boolean)data.v);
        }
        if (mainData instanceof ByteData) {
            ByteData data = (ByteData)mainData;
            return ByteTag.valueOf((byte)data.b);
        }
        if (mainData instanceof CharData) {
            CharData data = (CharData)mainData;
            return StringTag.valueOf((String)String.valueOf(data.c));
        }
        if (mainData instanceof DoubleData) {
            DoubleData data = (DoubleData)mainData;
            return DoubleTag.valueOf((double)data.d);
        }
        if (mainData instanceof FloatData) {
            FloatData data = (FloatData)mainData;
            return FloatTag.valueOf((float)data.f);
        }
        if (mainData instanceof IntData) {
            IntData data = (IntData)mainData;
            return IntTag.valueOf((int)data.value);
        }
        if (mainData instanceof LongData) {
            LongData data = (LongData)mainData;
            return LongTag.valueOf((long)data.l);
        }
        if (mainData instanceof ShortData) {
            ShortData data = (ShortData)mainData;
            return ShortTag.valueOf((short)data.aShort);
        }
        return compoundTag;
    }

    public static IData NBTToData(Tag tag) {
        if (tag instanceof ByteTag) {
            ByteTag nbt = (ByteTag)tag;
            return IData.valueOf(nbt.getAsByte());
        }
        if (tag instanceof ByteArrayTag) {
            ByteArrayTag nbt = (ByteArrayTag)tag;
            ListData<IData> listData = new ListData<IData>();
            for (ByteTag byteTag : nbt) {
                listData.addValue(IData.valueOf(byteTag.getAsByte()));
            }
            return listData;
        }
        if (tag instanceof DoubleTag) {
            DoubleTag nbt = (DoubleTag)tag;
            return IData.valueOf(nbt.getAsDouble());
        }
        if (tag instanceof FloatTag) {
            FloatTag nbt = (FloatTag)tag;
            return IData.valueOf(nbt.getAsFloat());
        }
        if (tag instanceof IntTag) {
            IntTag nbt = (IntTag)tag;
            return IData.valueOf(nbt.getAsInt());
        }
        if (tag instanceof IntArrayTag) {
            IntArrayTag nbt = (IntArrayTag)tag;
            ListData<IData> listData = new ListData<IData>();
            for (IntTag intTag : nbt) {
                listData.addValue(IData.valueOf(intTag.getAsInt()));
            }
            return listData;
        }
        if (tag instanceof LongTag) {
            LongTag nbt = (LongTag)tag;
            return IData.valueOf(nbt.getAsLong());
        }
        if (tag instanceof LongArrayTag) {
            LongArrayTag nbt = (LongArrayTag)tag;
            ListData<IData> listData = new ListData<IData>();
            for (LongTag longTag : nbt) {
                listData.addValue(IData.valueOf(longTag.getAsLong()));
            }
            return listData;
        }
        if (tag instanceof ShortTag) {
            ShortTag nbt = (ShortTag)tag;
            return IData.valueOf(nbt.getAsShort());
        }
        if (tag instanceof StringTag) {
            StringTag nbt = (StringTag)tag;
            return IData.valueOf(nbt.getAsString());
        }
        if (tag instanceof CollectionTag) {
            CollectionTag nbt = (CollectionTag)tag;
            ListData<IData> listData = new ListData<IData>();
            for (Tag tag1 : nbt) {
                listData.addValue(SDMSerializerHelper.NBTToData(tag1));
            }
            return listData;
        }
        if (tag instanceof ListTag) {
            ListTag nbt = (ListTag)tag;
            ListData<IData> listData = new ListData<IData>();
            for (Tag tag1 : nbt) {
                listData.addValue(SDMSerializerHelper.NBTToData(tag1));
            }
            return listData;
        }
        if (tag instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)tag;
            KeyData data1 = new KeyData();
            for (Map.Entry<String, Tag> stringTagEntry : ((CompoundTagAccessor)nbt).getTags().entrySet()) {
                data1.put(stringTagEntry.getKey(), SDMSerializerHelper.NBTToData(stringTagEntry.getValue()));
            }
            return data1;
        }
        throw new RuntimeException("Unsupported type !");
    }
}

