/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl.utils.multiThread;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import net.sixik.sdmcore.impl.utils.multiThread.Abstract.AbstractMultiThreadFinderMap;

public class MultiThreadFinderMap<K, V>
extends AbstractMultiThreadFinderMap<K, V> {
    private final long startTime;
    private final Map<K, V> map;
    private final AtomicReference<K> findObjectKey = new AtomicReference();
    private final AtomicReference<V> findObjectValue = new AtomicReference();
    private boolean isDebug = false;

    public MultiThreadFinderMap(Map<K, V> map) {
        this.startTime = System.nanoTime();
        this.map = map;
    }

    public MultiThreadFinderMap<K, V> setDebug() {
        this.isDebug = true;
        return this;
    }

    public K findMultiThreadKey(V object) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int threads = Math.min(this.map.size(), availableProcessors);
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        List<Map<K, V>> splitMaps = this.splitMap(threads, this.map);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (Map<K, V> map : splitMaps) {
            futures.add(executorService.submit(() -> {
                for (Map.Entry entry : subMap.entrySet()) {
                    if (this.findObjectKey.get() != null) {
                        return null;
                    }
                    if (!entry.getValue().equals(object)) continue;
                    this.findObjectKey.set(entry.getKey());
                    return null;
                }
                return null;
            }));
        }
        executorService.shutdown();
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (this.isDebug) {
            this.printExecutionTime();
        }
        return this.findObjectKey.get();
    }

    @Override
    public V findMultiThread(V object) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int threads = Math.min(this.map.size(), availableProcessors);
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        List<Map<K, V>> splitMaps = this.splitMap(threads, this.map);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (Map<K, V> map : splitMaps) {
            futures.add(executorService.submit(() -> {
                for (Object value : subMap.values()) {
                    if (this.findObjectValue.get() != null) {
                        return null;
                    }
                    if (!value.equals(object)) continue;
                    this.findObjectValue.set(value);
                    return null;
                }
                return null;
            }));
        }
        executorService.shutdown();
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (this.isDebug) {
            this.printExecutionTime();
        }
        return this.findObjectValue.get();
    }

    @Override
    public V findMultiThreadByKey(K object) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int threads = Math.min(this.map.size(), availableProcessors);
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        List<Map<K, V>> splitMaps = this.splitMap(threads, this.map);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (Map<K, V> map : splitMaps) {
            futures.add(executorService.submit(() -> {
                for (Object key : subMap.keySet()) {
                    if (this.findObjectValue.get() != null) {
                        return null;
                    }
                    if (!key.equals(object)) continue;
                    this.findObjectValue.set(subMap.get(key));
                    return null;
                }
                return null;
            }));
        }
        executorService.shutdown();
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (this.isDebug) {
            this.printExecutionTime();
        }
        return this.findObjectValue.get();
    }

    private List<Map<K, V>> splitMap(int threads, Map<K, V> map) {
        ArrayList<Map<K, V>> splitMaps = new ArrayList<Map<K, V>>();
        ArrayList<K> keys = new ArrayList<K>(map.keySet());
        int chunkSize = (int)Math.ceil((double)keys.size() / (double)threads);
        for (int i = 0; i < threads; ++i) {
            int start = i * chunkSize;
            int end = Math.min(start + chunkSize, keys.size());
            List subKeys = keys.subList(start, end);
            HashMap subMap = new HashMap();
            for (Object key : subKeys) {
                subMap.put(key, map.get(key));
            }
            splitMaps.add(subMap);
        }
        return splitMaps;
    }

    private void printExecutionTime() {
        long endTime = System.nanoTime();
        double durationInSeconds = (double)(endTime - this.startTime) / 1.0E9;
        System.out.println("MultiThread execution time: " + durationInSeconds + " seconds.");
    }

    @Override
    public V findSingleThread(V object) {
        for (V value : this.map.values()) {
            if (!value.equals(object)) continue;
            this.findObjectValue.set(value);
            break;
        }
        if (this.isDebug) {
            long endTime = System.nanoTime();
            long duration = endTime - this.startTime;
            double durationInSeconds = (double)duration / 1.0E9;
            System.out.println("SingleThread execution time: " + durationInSeconds + " seconds.");
        }
        return this.findObjectValue.get();
    }

    @Override
    public V findSingleThreadByKey(K object) {
        for (K value : this.map.keySet()) {
            if (!value.equals(object)) continue;
            this.findObjectValue.set(this.map.get(value));
            break;
        }
        if (this.isDebug) {
            long endTime = System.nanoTime();
            long duration = endTime - this.startTime;
            double durationInSeconds = (double)duration / 1.0E9;
            System.out.println("SingleThread execution time: " + durationInSeconds + " seconds.");
        }
        return this.findObjectValue.get();
    }

    public K findSingleThreadKey(V object) {
        for (Map.Entry<K, V> kvEntry : this.map.entrySet()) {
            if (!kvEntry.getValue().equals(object)) continue;
            this.findObjectKey.set(kvEntry.getKey());
            break;
        }
        if (this.isDebug) {
            long endTime = System.nanoTime();
            long duration = endTime - this.startTime;
            double durationInSeconds = (double)duration / 1.0E9;
            System.out.println("SingleThread execution time: " + durationInSeconds + " seconds.");
        }
        return this.findObjectKey.get();
    }
}

