/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl.utils.multiThread;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sixik.sdmcore.impl.utils.multiThread.Abstract.AbstractMultiThreadFinder;

public class MultiThreadFinderList<A>
extends AbstractMultiThreadFinder<A> {
    private final long startTime = System.nanoTime();
    private final List<A> array;
    private volatile A findObject = null;
    private boolean isDebug = false;

    public MultiThreadFinderList(List<A> array) {
        this.array = array;
    }

    public MultiThreadFinderList<A> setDebug() {
        this.isDebug = true;
        return this;
    }

    @Override
    public A findMultiThread(A object) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int threads = Math.min(this.array.size(), availableProcessors);
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        List<List<A>> splitLists = this.splitArray(threads, this.array);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        for (List<A> list : splitLists) {
            futures.add(executorService.submit(() -> {
                for (Object a : splitList) {
                    if (this.findObject != null) {
                        return null;
                    }
                    if (!a.equals(object)) continue;
                    MultiThreadFinderList multiThreadFinderList = this;
                    synchronized (multiThreadFinderList) {
                        if (this.findObject == null) {
                            this.findObject = a;
                        }
                    }
                    return null;
                }
                return null;
            }));
        }
        executorService.shutdown();
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (this.isDebug) {
            long endTime = System.nanoTime();
            long duration = endTime - this.startTime;
            double durationInSeconds = (double)duration / 1.0E9;
            System.out.println("MultiThread execution time: " + durationInSeconds + " seconds.");
        }
        return this.findObject;
    }

    @Override
    public A findSingleThread(A object) {
        for (A a1 : this.array) {
            if (!a1.equals(object)) continue;
            this.findObject = a1;
            break;
        }
        if (this.isDebug) {
            long endTime = System.nanoTime();
            long duration = endTime - this.startTime;
            double durationInSeconds = (double)duration / 1.0E9;
            System.out.println("SingleThread execution time: " + durationInSeconds + " seconds.");
        }
        return this.findObject;
    }

    private List<List<A>> splitArray(int threads, List<A> array) {
        ArrayList<List<A>> arrays = new ArrayList<List<A>>();
        int chunkSize = (int)Math.ceil((double)array.size() / (double)threads);
        for (int i = 0; i < threads; ++i) {
            int start = i * chunkSize;
            int end = Math.min(start + chunkSize, array.size());
            arrays.add(array.subList(start, end));
        }
        return arrays;
    }
}

