/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl.utils.multiThread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sixik.sdmcore.impl.utils.multiThread.Abstract.AbstractMultiThreadFinder;

public class MultiThreadFinderCollection<A>
extends AbstractMultiThreadFinder<A> {
    private final long startTime = System.nanoTime();
    private final Collection<A> collection;
    private volatile A findObject = null;
    private boolean isDebug = false;

    public MultiThreadFinderCollection(Collection<A> collection) {
        this.collection = collection;
    }

    public MultiThreadFinderCollection<A> setDebug() {
        this.isDebug = true;
        return this;
    }

    @Override
    public A findMultiThread(A object) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int threads = Math.min(this.collection.size(), availableProcessors);
        ExecutorService executorService = Executors.newFixedThreadPool(threads);
        List<List<A>> splitLists = this.splitArray(threads, this.collection);
        ArrayList futures = new ArrayList();
        for (List<A> list : splitLists) {
            futures.add(executorService.submit(() -> {
                for (Object a : splitList) {
                    if (this.findObject != null) {
                        return;
                    }
                    if (!a.equals(object)) continue;
                    this.findObject = a;
                    return;
                }
            }));
        }
        executorService.shutdown();
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        if (this.isDebug) {
            long endTime = System.nanoTime();
            long duration = endTime - this.startTime;
            double durationInSeconds = (double)duration / 1.0E9;
            System.out.println("MultiThread execution time: " + durationInSeconds + " seconds.");
        }
        return this.findObject;
    }

    @Override
    public A findSingleThread(A object) {
        for (A a1 : this.collection) {
            if (!a1.equals(object)) continue;
            this.findObject = a1;
            break;
        }
        if (this.isDebug) {
            long endTime = System.nanoTime();
            long duration = endTime - this.startTime;
            double durationInSeconds = (double)duration / 1.0E9;
            System.out.println("SingleThread execution time: " + durationInSeconds + " seconds.");
        }
        return this.findObject;
    }

    private List<List<A>> splitArray(int threads, Collection<A> array) {
        ArrayList<List<A>> arrays = new ArrayList<List<A>>();
        int chunkSize = (int)Math.ceil((double)array.size() / (double)threads);
        ArrayList<A> d1 = new ArrayList<A>(array);
        for (int i = 0; i < threads; ++i) {
            int start = i * chunkSize;
            int end = Math.min(start + chunkSize, d1.size());
            arrays.add(d1.subList(start, end));
        }
        return arrays;
    }
}

