/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sixik.sdmcore.SDMCore;
import org.jetbrains.annotations.Nullable;

public class SDMReflectionHelper {
    public static List<Field> getStaticFields(Class<?> cl) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : cl.getFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            list.add(field);
        }
        return list;
    }

    private static boolean isSupperClass(Class<?> cl, Class<?> cl2) {
        return SDMReflectionHelper.getParent(cl).contains(cl2);
    }

    public static Object cast(Object obj, Class<?> caster) {
        if (obj.getClass() == caster) {
            return obj;
        }
        if (SDMReflectionHelper.hasBasicValue(obj, caster)) {
            return SDMReflectionHelper.getBasicValues(obj, caster);
        }
        return caster.cast(obj);
    }

    public static Object tryCast(Object obj, Class<?> caster) {
        if (obj == null) {
            return null;
        }
        try {
            if (obj.getClass() == caster) {
                return obj;
            }
            if (SDMReflectionHelper.hasBasicValue(obj, caster)) {
                return SDMReflectionHelper.getBasicValues(obj, caster);
            }
            return caster.cast(obj);
        }
        catch (Exception e) {
            SDMCore.SDMLOGGER.addError(e);
            return null;
        }
    }

    public static boolean hasBasicValue(Object o, Class<?> caster) {
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            if (caster.equals(Boolean.TYPE)) {
                return true;
            }
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            if (caster.equals(Integer.TYPE)) {
                return true;
            }
        }
        if (o instanceof Float) {
            Float number = (Float)o;
            if (caster.equals(Float.TYPE)) {
                return true;
            }
        }
        if (o instanceof Double) {
            Double number = (Double)o;
            if (caster.equals(Double.TYPE)) {
                return true;
            }
        }
        if (o instanceof Byte) {
            Byte number = (Byte)o;
            if (caster.equals(Byte.TYPE)) {
                return true;
            }
        }
        if (o instanceof Character) {
            Character number = (Character)o;
            if (caster.equals(Character.TYPE)) {
                return true;
            }
        }
        if (o instanceof Short) {
            Short number = (Short)o;
            if (caster.equals(Short.TYPE)) {
                return true;
            }
        }
        return false;
    }

    public static Object getBasicValues(Object o, Class<?> caster) {
        if (o instanceof Boolean) {
            Boolean b = (Boolean)o;
            if (caster.equals(Boolean.TYPE)) {
                return (boolean)b;
            }
        }
        if (o instanceof Integer) {
            Integer i = (Integer)o;
            if (caster.equals(Integer.TYPE)) {
                return (int)i;
            }
        }
        if (o instanceof Float) {
            Float number = (Float)o;
            if (caster.equals(Float.TYPE)) {
                return Float.valueOf(number.floatValue());
            }
        }
        if (o instanceof Double) {
            Double number = (Double)o;
            if (caster.equals(Double.TYPE)) {
                return (double)number;
            }
        }
        if (o instanceof Byte) {
            Byte number = (Byte)o;
            if (caster.equals(Byte.TYPE)) {
                return (byte)number;
            }
        }
        if (o instanceof Character) {
            Character number = (Character)o;
            if (caster.equals(Character.TYPE)) {
                return Character.valueOf(number.charValue());
            }
        }
        if (o instanceof Short) {
            Short number = (Short)o;
            if (caster.equals(Short.TYPE)) {
                return (short)number;
            }
        }
        return o;
    }

    @Nullable
    public static Object canCastAndReturn(Object obj, Class<?> caster) {
        return SDMReflectionHelper.canCast(obj, caster) ? SDMReflectionHelper.tryCast(obj, caster) : null;
    }

    public static boolean canCast(Object obj, Class<?> caster) {
        try {
            if (obj.getClass() == caster) {
                return true;
            }
            List<Class<?>> d1 = SDMReflectionHelper.getParent(obj.getClass());
            if (d1.contains(caster)) {
                return true;
            }
            d1 = SDMReflectionHelper.getParent(caster);
            if (d1.contains(obj.getClass())) {
                return true;
            }
        }
        catch (Exception e) {
            SDMCore.SDMLOGGER.addError(e);
        }
        return false;
    }

    public static boolean canCast(Class<?> obj, Class<?> caster) {
        try {
            if (obj == caster) {
                return true;
            }
            List<Class<?>> d1 = SDMReflectionHelper.getParent(obj);
            if (d1.contains(caster)) {
                return true;
            }
            d1 = SDMReflectionHelper.getParent(caster);
            if (d1.contains(obj)) {
                return true;
            }
        }
        catch (Exception e) {
            SDMCore.SDMLOGGER.addError(e);
        }
        return false;
    }

    public static List<Class<?>> getParent(Class<?> obj) {
        List<Class<?>> classes = Collections.synchronizedList(new ArrayList());
        for (Class<?> anInterface : obj.getInterfaces()) {
            classes.add(anInterface);
            classes.addAll(SDMReflectionHelper.getParent(anInterface));
        }
        if (obj.getSuperclass() != null) {
            classes.add(obj.getSuperclass());
            classes.addAll(SDMReflectionHelper.getParent(obj.getSuperclass()));
        }
        return classes;
    }

    public static Class<?> getArrayType(List<?> array) {
        Type type = SDMReflectionHelper.getGenericType(array);
        if (type instanceof Class) {
            return (Class)type;
        }
        return Object.class;
    }

    public static Type getGenericType(List<?> list) {
        Type superclass = list.getClass().getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)superclass;
            return parameterizedType.getActualTypeArguments()[0];
        }
        return null;
    }
}

