/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sixik.sdmcore.SDMCore;

public class LangEngineLogger {
    private String pathToFile;
    private List<String> messages = Collections.synchronizedList(new ArrayList());

    public LangEngineLogger(String pathToFile) {
        this.pathToFile = pathToFile;
        this.createFile();
    }

    public LangEngineLogger(File file) {
        this.pathToFile = file.toString();
        this.createFile();
    }

    public LangEngineLogger(Path file) {
        this.pathToFile = file.toString();
        this.createFile();
    }

    public void addInfo(Object message) {
        String str = this.getTime() + this.getType(Type.INFO) + ": " + String.valueOf(message);
        System.out.println(str);
        this.write(str);
    }

    public void addError(Object message) {
        String str = this.getTime() + this.getType(Type.ERROR) + ": " + String.valueOf(message);
        System.out.println(str);
        this.write(str);
    }

    public void addError(Exception e) {
        String str = this.getTime() + this.getType(Type.ERROR) + ": " + String.valueOf(e) + "\n";
        this.printStackTrace(str, e);
    }

    public void printStackTrace(String str, Throwable s) {
        StringBuilder strBuilder = new StringBuilder(str);
        for (StackTraceElement stackTraceElement : s.getStackTrace()) {
            strBuilder.append("\t").append(" ").append("at").append(" ").append(stackTraceElement).append("\n");
        }
        str = strBuilder.toString();
        for (Serializable serializable : s.getSuppressed()) {
            this.printStackTrace(str, (Throwable)serializable);
        }
        Throwable ourCause = s.getCause();
        if (ourCause != null) {
            this.printStackTrace(str, ourCause);
        }
        System.out.println(str);
        this.write(str);
    }

    public void addDebug(Object message) {
        String str = this.getTime() + this.getType(Type.DEBUG) + ": " + String.valueOf(message);
        System.out.println(str);
        this.write(str);
    }

    protected void createFile() {
        File file = new File(this.pathToFile);
        if (!file.exists()) {
            if (file.isDirectory()) {
                file.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                SDMCore.LOGGER.error(e.toString());
            }
        } else {
            try {
                FileWriter d1 = new FileWriter(file);
                d1.write("");
                d1.close();
            }
            catch (IOException e) {
                SDMCore.LOGGER.error(e.toString());
            }
        }
    }

    protected void write(String message) {
        try {
            File file = new File(this.pathToFile);
            FileWriter d1 = new FileWriter(file, true);
            PrintWriter writer = new PrintWriter(d1);
            writer.println(message);
            writer.close();
        }
        catch (IOException e) {
            SDMCore.LOGGER.error(e.toString());
        }
    }

    protected String getTime() {
        LocalTime date = LocalTime.now();
        return "[" + String.valueOf(date.getHour() < 9 ? "0" + date.getHour() : Integer.valueOf(date.getHour())) + ":" + String.valueOf(date.getMinute() < 9 ? "0" + date.getMinute() : Integer.valueOf(date.getMinute())) + ":" + String.valueOf(date.getSecond() < 9 ? "0" + date.getSecond() : Integer.valueOf(date.getSecond())) + "]";
    }

    protected String getType(Type type) {
        return " [" + type.name().toUpperCase() + "]";
    }

    public static enum Type {
        INFO,
        ERROR,
        DEBUG;

    }
}

