/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.sixik.sdmcore.SDMCore;

public class MappetData {
    public static final Pattern METHOD_PATTERN = Pattern.compile("m_\\d+_");
    public static final Pattern FIELD_PATTERN = Pattern.compile("f_\\d+_");
    public static ConcurrentHashMap<String, String> FIELDS = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, String> METHODS = new ConcurrentHashMap();

    public static void clearData() {
        FIELDS.clear();
        METHODS.clear();
    }

    public static boolean isValidNameMethod(String method) {
        Matcher matcher = METHOD_PATTERN.matcher(method);
        return matcher.matches();
    }

    public static boolean isValidNameField(String method) {
        Matcher matcher = FIELD_PATTERN.matcher(method);
        return matcher.matches();
    }

    public static synchronized String getNameForMethod(String method) {
        if (MappetData.isValidNameMethod(method)) {
            String d1 = METHODS.get(method);
            if (d1 == null) {
                return method;
            }
            return d1;
        }
        return method;
    }

    public static synchronized String getNameForField(String field) {
        if (MappetData.isValidNameField(field)) {
            String d1 = FIELDS.get(field);
            if (d1 == null) {
                return field;
            }
            return d1;
        }
        return field;
    }

    public static String getNameForFieldFromFile(String field) {
        if (MappetData.isValidNameField(field)) {
            ResourceLocation resourceLocation = ResourceLocation.tryBuild((String)"sdmcore", (String)"maps/fields.csv");
            try {
                Optional resource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
                BufferedReader reader = new BufferedReader(new InputStreamReader(((Resource)resource.get()).open(), StandardCharsets.UTF_8));
                for (String s : reader.lines().toList()) {
                    String[] values = s.split("\\,");
                    if (!values[0].equals(field)) continue;
                    return values[1];
                }
            }
            catch (IOException e) {
                SDMCore.LOGGER.error(e.toString());
            }
        }
        return field;
    }

    public static String getNameForMethodFromFile(String method) {
        if (MappetData.isValidNameMethod(method)) {
            ResourceLocation resourceLocation = ResourceLocation.tryBuild((String)"sdmcore", (String)"maps/methods.csv");
            try {
                Optional resource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
                BufferedReader reader = new BufferedReader(new InputStreamReader(((Resource)resource.get()).open(), StandardCharsets.UTF_8));
                for (String s : reader.lines().toList()) {
                    String[] values = s.split("\\,");
                    if (!values[0].equals(method)) continue;
                    return values[1];
                }
            }
            catch (IOException e) {
                SDMCore.LOGGER.error(e.toString());
            }
        }
        return method;
    }

    public static void loadAllMapData() {
        String[] values;
        BufferedReader reader;
        Optional resource;
        ResourceLocation resourceLocation = ResourceLocation.tryBuild((String)"sdmcore", (String)"maps/fields.csv");
        try {
            resource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
            reader = new BufferedReader(new InputStreamReader(((Resource)resource.get()).open(), StandardCharsets.UTF_8));
            for (String s : reader.lines().toList()) {
                values = s.split("\\,");
                FIELDS.put(values[0], values[1]);
            }
        }
        catch (IOException e) {
            SDMCore.LOGGER.error(e.toString());
        }
        resourceLocation = ResourceLocation.tryBuild((String)"sdmcore", (String)"maps/methods.csv");
        try {
            resource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
            reader = new BufferedReader(new InputStreamReader(((Resource)resource.get()).open(), StandardCharsets.UTF_8));
            for (String s : reader.lines().toList()) {
                values = s.split("\\,");
                METHODS.put(values[0], values[1]);
            }
        }
        catch (IOException e) {
            SDMCore.LOGGER.error(e.toString());
        }
    }
}

