/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmcore.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.sixik.sdmcore.SDMCore;

public class AssetLoader {
    public static byte[] readResourceBytes(ResourceLocation resourceLocation) {
        try {
            Optional resource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
            return ((Resource)resource.get()).open().readAllBytes();
        }
        catch (IOException e) {
            SDMCore.SDMLOGGER.addError(e);
            return new byte[0];
        }
    }

    public static void loadFileFromAssets(String modid, String fileName) {
        ResourceLocation resourceLocation = ResourceLocation.tryBuild((String)modid, (String)fileName);
        try {
            String line;
            Optional resource = Minecraft.getInstance().getResourceManager().getResource(resourceLocation);
            BufferedReader reader = new BufferedReader(new InputStreamReader(((Resource)resource.get()).open(), StandardCharsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

