/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.init;

import com.tristankechlo.livingthings.init.ModArmorMaterial;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModFoods;
import com.tristankechlo.livingthings.item.LexiconItem;
import com.tristankechlo.livingthings.item.OstrichEggItem;
import com.tristankechlo.livingthings.platform.IPlatformHelper;
import com.tristankechlo.livingthings.platform.RegistrationProvider;
import com.tristankechlo.livingthings.platform.RegistryObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class ModItems {
    public static final RegistrationProvider<Item> ITEMS = RegistrationProvider.get(BuiltInRegistries.ITEM, "livingthings");
    public static final List<RegistryObject<? extends Item>> ALL_ITEMS = new ArrayList<RegistryObject<? extends Item>>();
    public static final List<RegistryObject<Item>> SPAWN_EGGS;
    public static final RegistryObject<Item> SHARK_TOOTH;
    public static final RegistryObject<Item> OSTRICH_EGG;
    public static final RegistryObject<Item> CRAB;
    public static final RegistryObject<Item> COOKED_CRAB;
    public static final RegistryObject<Item> CRAB_SHELL;
    public static final RegistryObject<Item> LEXICON;
    public static final RegistryObject<Item> BANANA;
    public static final RegistryObject<Item> ANCIENT_HELMET;
    public static final RegistryObject<Item> OSTRICH;
    public static final RegistryObject<Item> COOKED_OSTRICH;
    public static final RegistryObject<Item> ELEPHANT;
    public static final RegistryObject<Item> COOKED_ELEPHANT;
    public static final RegistryObject<Item> LION;
    public static final RegistryObject<Item> COOKED_LION;
    public static final RegistryObject<Item> GIRAFFE;
    public static final RegistryObject<Item> COOKED_GIRAFFE;
    public static final RegistryObject<Item> SEAHORSE_BUCKET;
    public static final RegistryObject<Item> ELEPHANT_SPAWN_EGG;
    public static final RegistryObject<Item> GIRAFFE_SPAWN_EGG;
    public static final RegistryObject<Item> LION_SPAWN_EGG;
    public static final RegistryObject<Item> SHARK_SPAWN_EGG;
    public static final RegistryObject<Item> PENGUIN_SPAWN_EGG;
    public static final RegistryObject<Item> OSTRICH_SPAWN_EGG;
    public static final RegistryObject<Item> FLAMINGO_SPAWN_EGG;
    public static final RegistryObject<Item> CRAB_SPAWN_EGG;
    public static final RegistryObject<Item> MANTARAY_SPAWN_EGG;
    public static final RegistryObject<Item> RACCOON_SPAWN_EGG;
    public static final RegistryObject<Item> OWL_SPAWN_EGG;
    public static final RegistryObject<Item> ANCIENT_BLAZE_SPAWN_EGG;
    public static final RegistryObject<Item> KOALA_SPAWN_EGG;
    public static final RegistryObject<Item> SNAIL_SPAWN_EGG;
    public static final RegistryObject<Item> MONKEY_SPAWN_EGG;
    public static final RegistryObject<Item> NETHER_KNIGHT_SPAWN_EGG;
    public static final RegistryObject<Item> SHROOMIE_SPAWN_EGG;
    public static final RegistryObject<Item> SEAHORSE_SPAWN_EGG;
    public static final RegistryObject<Item> BABY_ENDER_DRAGON_SPAWN_EGG;
    public static final RegistryObject<Item> PEACOCK_SPAWN_EGG;

    public static void init() {
    }

    public static Item.Properties normalProps() {
        return new Item.Properties();
    }

    private static RegistryObject<Item> registerItem(String name, Supplier<Item> item) {
        RegistryObject<Item> registeredItem = ITEMS.register(name, item);
        ALL_ITEMS.add(registeredItem);
        return registeredItem;
    }

    static {
        SHARK_TOOTH = ModItems.registerItem("shark_tooth", () -> new Item(ModItems.normalProps()));
        OSTRICH_EGG = ModItems.registerItem("ostrich_egg", () -> new OstrichEggItem(ModItems.normalProps().stacksTo(16)));
        CRAB = ModItems.registerItem("crab", () -> new Item(ModItems.normalProps().food(ModFoods.CRAB)));
        COOKED_CRAB = ModItems.registerItem("cooked_crab", () -> new Item(ModItems.normalProps().food(ModFoods.COOKED_CRAB)));
        CRAB_SHELL = ModItems.registerItem("crab_shell", () -> new Item(ModItems.normalProps()));
        LEXICON = ModItems.registerItem("lexicon", () -> new LexiconItem(ModItems.normalProps().stacksTo(1)));
        BANANA = ModItems.registerItem("banana", () -> new Item(ModItems.normalProps().food(ModFoods.BANANA)));
        ANCIENT_HELMET = ModItems.registerItem("ancient_helmet", () -> new ArmorItem(ModArmorMaterial.ANCIENT.asHolder(), ArmorItem.Type.HELMET, ModItems.normalProps().stacksTo(1)));
        OSTRICH = ModItems.registerItem("ostrich", () -> new Item(ModItems.normalProps().food(ModFoods.OSTRICH)));
        COOKED_OSTRICH = ModItems.registerItem("cooked_ostrich", () -> new Item(ModItems.normalProps().food(ModFoods.COOKED_OSTRICH)));
        ELEPHANT = ModItems.registerItem("elephant", () -> new Item(ModItems.normalProps().food(ModFoods.ELEPHANT)));
        COOKED_ELEPHANT = ModItems.registerItem("cooked_elephant", () -> new Item(ModItems.normalProps().food(ModFoods.COOKED_ELEPHANT)));
        LION = ModItems.registerItem("lion", () -> new Item(ModItems.normalProps().food(ModFoods.LION)));
        COOKED_LION = ModItems.registerItem("cooked_lion", () -> new Item(ModItems.normalProps().food(ModFoods.COOKED_LION)));
        GIRAFFE = ModItems.registerItem("giraffe", () -> new Item(ModItems.normalProps().food(ModFoods.GIRAFFE)));
        COOKED_GIRAFFE = ModItems.registerItem("cooked_giraffe", () -> new Item(ModItems.normalProps().food(ModFoods.COOKED_GIRAFFE)));
        SEAHORSE_BUCKET = ModItems.registerItem("seahorse_bucket", () -> IPlatformHelper.INSTANCE.createMobBucketItem(ModEntityTypes.SEAHORSE, (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, ModItems.normalProps().stacksTo(1)));
        ELEPHANT_SPAWN_EGG = ITEMS.register("elephant_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.ELEPHANT::get, 0, 0x4E4E4E, ModItems.normalProps()));
        GIRAFFE_SPAWN_EGG = ITEMS.register("giraffe_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.GIRAFFE::get, 15446636, 7888704, ModItems.normalProps()));
        LION_SPAWN_EGG = ITEMS.register("lion_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.LION::get, 15446636, 0xFFFFFF, ModItems.normalProps()));
        SHARK_SPAWN_EGG = ITEMS.register("shark_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.SHARK::get, 7369095, 5855851, ModItems.normalProps()));
        PENGUIN_SPAWN_EGG = ITEMS.register("penguin_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.PENGUIN::get, 0, 0xFFFFFF, ModItems.normalProps()));
        OSTRICH_SPAWN_EGG = ITEMS.register("ostrich_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.OSTRICH::get, 1248520, 10841947, ModItems.normalProps()));
        FLAMINGO_SPAWN_EGG = ITEMS.register("flamingo_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.FLAMINGO::get, 15960457, 2950148, ModItems.normalProps()));
        CRAB_SPAWN_EGG = ITEMS.register("crab_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.CRAB::get, 15417396, 7565423, ModItems.normalProps()));
        MANTARAY_SPAWN_EGG = ITEMS.register("mantaray_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.MANTARAY::get, 2198, 5855851, ModItems.normalProps()));
        RACCOON_SPAWN_EGG = ITEMS.register("raccoon_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.RACCOON::get, 0x6E6E6E, 0, ModItems.normalProps()));
        OWL_SPAWN_EGG = ITEMS.register("owl_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.OWL::get, 15587285, 7223348, ModItems.normalProps()));
        ANCIENT_BLAZE_SPAWN_EGG = ITEMS.register("ancient_blaze_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.ANCIENT_BLAZE::get, 16167424, 16775293, ModItems.normalProps()));
        KOALA_SPAWN_EGG = ITEMS.register("koala_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.KOALA::get, 0x565050, 0x8F8686, ModItems.normalProps()));
        SNAIL_SPAWN_EGG = ITEMS.register("snail_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.SNAIL::get, 35677284, 341384, ModItems.normalProps()));
        MONKEY_SPAWN_EGG = ITEMS.register("monkey_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.MONKEY::get, 10051392, 7555121, ModItems.normalProps()));
        NETHER_KNIGHT_SPAWN_EGG = ITEMS.register("nether_knight_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.NETHER_KNIGHT::get, 1579548, 10693281, ModItems.normalProps()));
        SHROOMIE_SPAWN_EGG = ITEMS.register("shroomie_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.SHROOMIE::get, 12097165, 14366735, ModItems.normalProps()));
        SEAHORSE_SPAWN_EGG = ITEMS.register("seahorse_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.SEAHORSE::get, 0x22FF22, 14366735, ModItems.normalProps()));
        BABY_ENDER_DRAGON_SPAWN_EGG = ITEMS.register("baby_ender_dragon_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.BABY_ENDER_DRAGON::get, 2104868, 16734669, ModItems.normalProps()));
        PEACOCK_SPAWN_EGG = ITEMS.register("peacock_spawn_egg", () -> IPlatformHelper.INSTANCE.createSpawnEgg(ModEntityTypes.PEACOCK::get, 1146823, 8836155, ModItems.normalProps()));
        SPAWN_EGGS = List.of(ELEPHANT_SPAWN_EGG, GIRAFFE_SPAWN_EGG, LION_SPAWN_EGG, SHARK_SPAWN_EGG, PENGUIN_SPAWN_EGG, OSTRICH_SPAWN_EGG, FLAMINGO_SPAWN_EGG, CRAB_SPAWN_EGG, MANTARAY_SPAWN_EGG, RACCOON_SPAWN_EGG, OWL_SPAWN_EGG, ANCIENT_BLAZE_SPAWN_EGG, KOALA_SPAWN_EGG, SNAIL_SPAWN_EGG, MONKEY_SPAWN_EGG, NETHER_KNIGHT_SPAWN_EGG, SHROOMIE_SPAWN_EGG, SEAHORSE_SPAWN_EGG, BABY_ENDER_DRAGON_SPAWN_EGG, PEACOCK_SPAWN_EGG);
    }
}

