/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.BooleanValue;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;

public final class SharkConfig
extends EntityConfig {
    private static final SharkConfig INSTANCE = new SharkConfig();
    public final BooleanValue canAttack = new BooleanValue("canAttack", true);
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 22.0, 1.0, 1024.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 1.05, 0.0, 1024.0);
    public final NumberValue.DoubleValue attackDamage = new NumberValue.DoubleValue("attackDamage", 6.0, 0.0, 2048.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 3, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", SharkConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);

    private SharkConfig() {
        super("shark");
        this.registerConfigValues(this.canAttack, this.health, this.movementSpeed, this.attackDamage, this.maxSpawnedInChunk, this.spawnBiomes);
    }

    public static SharkConfig get() {
        return INSTANCE;
    }

    public static boolean canAttack() {
        return SharkConfig.INSTANCE.canAttack.get();
    }

    public static double health() {
        return (Double)SharkConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)SharkConfig.INSTANCE.movementSpeed.get();
    }

    public static double attackDamage() {
        return (Double)SharkConfig.INSTANCE.attackDamage.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)SharkConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(13, 2, 3, new ResourceKey[]{Biomes.OCEAN, Biomes.DEEP_OCEAN, Biomes.FROZEN_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.COLD_OCEAN, Biomes.DEEP_COLD_OCEAN, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN}));
    }
}

