/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;

public final class OwlConfig
extends EntityConfig {
    private static final OwlConfig INSTANCE = new OwlConfig();
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 10.0, 1.0, 1024.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.25, 0.0, 1024.0);
    public final NumberValue.DoubleValue flyingSpeed = new NumberValue.DoubleValue("flyingSpeed", 0.5, 0.0, 1024.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 6, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", OwlConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);
    public final NumberValue.IntegerValue colorWhiteWeight = new NumberValue.IntegerValue("colorWhiteWeight", 33, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorBrownWeight = new NumberValue.IntegerValue("colorBrownWeight", 33, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorBlackWeight = new NumberValue.IntegerValue("colorBlackWeight", 33, 0, Integer.MAX_VALUE);

    private OwlConfig() {
        super("owl");
        this.registerConfigValues(this.health, this.movementSpeed, this.flyingSpeed, this.maxSpawnedInChunk, this.spawnBiomes);
        this.registerForCategory("colorWeights", this.colorWhiteWeight, this.colorBrownWeight, this.colorBlackWeight);
    }

    public static OwlConfig get() {
        return INSTANCE;
    }

    public static double health() {
        return (Double)OwlConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)OwlConfig.INSTANCE.movementSpeed.get();
    }

    public static double flyingSpeed() {
        return (Double)OwlConfig.INSTANCE.flyingSpeed.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)OwlConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(22, 3, 6, new ResourceKey[]{Biomes.FOREST, Biomes.BIRCH_FOREST, Biomes.OLD_GROWTH_BIRCH_FOREST, Biomes.DARK_FOREST, Biomes.FLOWER_FOREST, Biomes.WOODED_BADLANDS, Biomes.TAIGA, Biomes.OLD_GROWTH_PINE_TAIGA, Biomes.OLD_GROWTH_SPRUCE_TAIGA, Biomes.CHERRY_GROVE}));
    }
}

