/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.upgrade;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.upgrade.AbstractUpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class FortuneUpgradeItem
extends AbstractUpgradeItem {
    private static final Component HELP = IdentifierUtil.createTranslation("item", "fortune_upgrade.help");
    private final int fortuneLevel;
    private final Component name;

    public FortuneUpgradeItem(UpgradeRegistry registry, int fortuneLevel) {
        super(new Item.Properties(), registry, HELP);
        this.fortuneLevel = fortuneLevel;
        this.name = IdentifierUtil.createTranslation("item", "fortune_upgrade." + fortuneLevel);
    }

    @Override
    public long getEnergyUsage() {
        if (this.fortuneLevel == 1) {
            return Platform.INSTANCE.getConfig().getUpgrade().getFortune1UpgradeEnergyUsage();
        }
        if (this.fortuneLevel == 2) {
            return Platform.INSTANCE.getConfig().getUpgrade().getFortune2UpgradeEnergyUsage();
        }
        return Platform.INSTANCE.getConfig().getUpgrade().getFortune3UpgradeEnergyUsage();
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public Component getName(ItemStack stack) {
        return this.name;
    }
}

