/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallTextClientTooltipComponent;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public abstract class AbstractSideButtonWidget
extends Button {
    public static final int SIZE = 18;
    private static final ResourceLocation SPRITE = IdentifierUtil.createIdentifier("widget/side_button/base");
    private static final ResourceLocation HOVERED_SPRITE = IdentifierUtil.createIdentifier("widget/side_button/hovered");
    private static final ResourceLocation HOVER_OVERLAY_SPRITE = IdentifierUtil.createIdentifier("widget/side_button/hover_overlay");
    private static final int ICON_SIZE = 16;
    @Nullable
    private ClientTooltipComponent warning;

    protected AbstractSideButtonWidget(Button.OnPress pressAction) {
        super(-1, -1, 18, 18, (Component)Component.empty(), pressAction, DEFAULT_NARRATION);
    }

    protected abstract ResourceLocation getSprite();

    public void setWarning(@Nullable Component text) {
        if (text == null) {
            this.warning = null;
            return;
        }
        this.warning = new SmallTextClientTooltipComponent((Component)text.copy().withStyle(ChatFormatting.RED));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(this.isHovered ? HOVERED_SPRITE : SPRITE, this.getX(), this.getY(), 18, 18);
        graphics.blitSprite(this.getSprite(), this.getX() + 1, this.getY() + 1, 16, 16);
        if (this.isHovered) {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            graphics.blitSprite(HOVER_OVERLAY_SPRITE, this.getX(), this.getY(), 18, 18);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof AbstractBaseScreen) {
                AbstractBaseScreen baseScreen = (AbstractBaseScreen)screen;
                baseScreen.setDeferredTooltip(this.buildTooltip());
            }
        }
        if (this.warning != null) {
            this.renderWarning(graphics);
        }
    }

    private void renderWarning(GuiGraphics graphics) {
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 200.0f);
        graphics.blitSprite(Sprites.WARNING, this.getX() + 18 - 10 + 2, this.getY() + 18 - 10 + 2, 10, 10);
        graphics.pose().popPose();
    }

    protected List<ClientTooltipComponent> buildTooltip() {
        Component helpText;
        ArrayList<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
        ClientTooltipComponent title = ClientTooltipComponent.create((FormattedCharSequence)this.getTitle().getVisualOrderText());
        lines.add(title);
        this.getSubText().forEach(line -> lines.add(ClientTooltipComponent.create((FormattedCharSequence)line.getVisualOrderText())));
        if (this.warning != null) {
            lines.add(this.warning);
        }
        if ((helpText = this.getHelpText()) != null) {
            lines.add(HelpClientTooltipComponent.create(helpText));
        }
        return lines;
    }

    protected abstract MutableComponent getTitle();

    protected abstract List<MutableComponent> getSubText();

    @Nullable
    protected Component getHelpText() {
        return null;
    }
}

