/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.packet.c2s;

import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewProvider;
import com.refinedmods.refinedstorage.api.network.impl.autocrafting.TimeoutableCancellationToken;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.autocrafting.preview.AutocraftingPreviewStyle;
import com.refinedmods.refinedstorage.common.support.packet.PacketContext;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.resource.ResourceCodecs;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record AutocraftingPreviewRequestPacket(UUID id, PlatformResourceKey resource, long amount, AutocraftingPreviewStyle style) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AutocraftingPreviewRequestPacket> PACKET_TYPE = new CustomPacketPayload.Type(IdentifierUtil.createIdentifier("autocrafting_preview_request"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AutocraftingPreviewRequestPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, AutocraftingPreviewRequestPacket::id, ResourceCodecs.STREAM_CODEC, AutocraftingPreviewRequestPacket::resource, (StreamCodec)ByteBufCodecs.VAR_LONG, AutocraftingPreviewRequestPacket::amount, (StreamCodec)PlatformUtil.enumStreamCodec((Enum[])AutocraftingPreviewStyle.values()), AutocraftingPreviewRequestPacket::style, AutocraftingPreviewRequestPacket::new);

    public static void handle(AutocraftingPreviewRequestPacket packet, PacketContext ctx) {
        AbstractContainerMenu abstractContainerMenu = ctx.getPlayer().containerMenu;
        if (abstractContainerMenu instanceof PreviewProvider) {
            PreviewProvider provider = (PreviewProvider)abstractContainerMenu;
            ServerPlayer player = (ServerPlayer)ctx.getPlayer();
            AutocraftingPreviewRequestPacket.handle(packet, provider, player);
        }
    }

    private static void handle(AutocraftingPreviewRequestPacket packet, PreviewProvider provider, ServerPlayer player) {
        if (packet.style == AutocraftingPreviewStyle.LIST) {
            provider.getPreview(packet.resource(), packet.amount(), new TimeoutableCancellationToken()).thenAccept(optionalPreview -> optionalPreview.ifPresent(preview -> S2CPackets.sendAutocraftingPreviewResponse(player, packet.id, preview)));
        } else if (packet.style == AutocraftingPreviewStyle.TREE) {
            provider.getTreePreview(packet.resource(), packet.amount(), new TimeoutableCancellationToken()).thenAccept(optionalPreview -> optionalPreview.ifPresent(preview -> S2CPackets.sendAutocraftingTreePreviewResponse(player, packet.id, preview)));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_TYPE;
    }
}

