/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.List;
import java.util.function.LongFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

final class StorageTooltipHelper {
    private StorageTooltipHelper() {
    }

    static void addAmountStoredWithoutCapacity(List<Component> tooltip, long stored, LongFunction<String> quantityFormatter) {
        tooltip.add((Component)IdentifierUtil.createTranslation("misc", "stored", Component.literal((String)quantityFormatter.apply(stored)).withStyle(ChatFormatting.WHITE)).withStyle(ChatFormatting.GRAY));
    }

    static void addAmountStoredWithCapacity(List<Component> tooltip, long stored, long capacity, LongFunction<String> quantityFormatter) {
        if (capacity <= 0L) {
            StorageTooltipHelper.addAmountStoredWithoutCapacity(tooltip, stored, quantityFormatter);
            return;
        }
        int progress = (int)((double)stored / (double)capacity * 100.0);
        tooltip.add((Component)IdentifierUtil.createTranslation("misc", "stored_with_capacity", Component.literal((String)quantityFormatter.apply(stored)).withStyle(ChatFormatting.WHITE), Component.literal((String)quantityFormatter.apply(capacity)).withStyle(ChatFormatting.WHITE), Component.literal((String)String.valueOf(progress))).withStyle(ChatFormatting.GRAY));
    }
}

