/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.ListBuilder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ErrorHandlingListCodec<E>
implements Codec<List<E>> {
    private static final String ERROR_MESSAGE = "Refined Storage could not load a resource in storage.\nThis could be because the resource no longer exists after a mod update, or if the data format of the\nresource has changed. In any case, this is NOT caused by Refined Storage.\nRefined Storage will try to gracefully handle this problem and continue to load the storage data.\nThe problematic resource might end up being removed from storage, or may no longer have any additional data\nassociated with it.\nError message:";
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorHandlingListCodec.class);
    private final Codec<E> elementCodec;

    ErrorHandlingListCodec(Codec<E> elementCodec) {
        this.elementCodec = elementCodec;
    }

    public <T> DataResult<T> encode(List<E> input, DynamicOps<T> ops, T prefix) {
        ListBuilder builder = ops.listBuilder();
        for (E element : input) {
            builder.add(this.elementCodec.encodeStart(ops, element));
        }
        return builder.build(prefix);
    }

    public <T> DataResult<Pair<List<E>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getList(input).setLifecycle(Lifecycle.stable()).flatMap(stream -> {
            DecoderState decoder = new DecoderState(ops);
            stream.accept(decoder::accept);
            return decoder.build();
        });
    }

    public String toString() {
        return "ErrorHandlingListCodec[" + String.valueOf(this.elementCodec) + "]";
    }

    private class DecoderState<T> {
        private final DynamicOps<T> ops;
        private final List<E> elements = new ArrayList();

        private DecoderState(DynamicOps<T> ops) {
            this.ops = ops;
        }

        private void accept(T value) {
            DataResult elementResult = ErrorHandlingListCodec.this.elementCodec.decode(this.ops, value);
            elementResult.error().ifPresent(error -> LOGGER.warn("{} {}", (Object)ErrorHandlingListCodec.ERROR_MESSAGE, (Object)error.message()));
            elementResult.resultOrPartial().ifPresent(pair -> this.elements.add(pair.getFirst()));
        }

        private DataResult<Pair<List<E>, T>> build() {
            return DataResult.success((Object)Pair.of(this.elements, (Object)this.ops.empty()));
        }
    }
}

