/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiskStateChangeListener
implements StateTrackedStorage.Listener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskStateChangeListener.class);
    private final BlockEntity blockEntity;
    private final RateLimiter rateLimiter = RateLimiter.create((double)1.0);
    private boolean syncRequested;

    public DiskStateChangeListener(BlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    public void onStorageStateChanged() {
        this.syncRequested = true;
    }

    public void updateIfNecessary() {
        if (!this.syncRequested) {
            return;
        }
        if (!this.rateLimiter.tryAcquire()) {
            return;
        }
        LOGGER.debug("Disk state change for block at {}", (Object)this.blockEntity.getBlockPos());
        this.syncRequested = false;
        PlatformUtil.sendBlockUpdateToClient(this.blockEntity.getLevel(), this.blockEntity.getBlockPos());
    }
}

