/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.patterngrid;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.PatternType;
import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.ProcessingMatrixInputResourceContainer;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProcessingMatrixResourceSlot
extends ResourceSlot {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessingMatrixResourceSlot.class);
    private static final Component CLICK_TO_CONFIGURE_AMOUNT_AND_ALTERNATIVES = IdentifierUtil.createTranslationAsHeading("gui", "pattern_grid.processing.click_to_configure_amount_and_alternatives");
    private static final MutableComponent INPUT_HELP = IdentifierUtil.createTranslation("gui", "pattern_grid.processing.input_slots_help");
    private static final MutableComponent OUTPUT_HELP = IdentifierUtil.createTranslation("gui", "pattern_grid.processing.output_slots_help");
    private final Supplier<PatternType> patternTypeSupplier;
    private final boolean input;
    private final int startY;
    private final int endY;
    private Set<ResourceLocation> cachedAllowedAlternatives;

    ProcessingMatrixResourceSlot(ResourceContainer resourceContainer, int index, int x, int y, boolean input, Supplier<PatternType> patternTypeSupplier, Pair<Integer, Integer> startEndY) {
        super(resourceContainer, index, (Component)(input ? INPUT_HELP : OUTPUT_HELP), x, y, ResourceSlotType.FILTER_WITH_AMOUNT);
        Set<Object> set;
        this.patternTypeSupplier = patternTypeSupplier;
        if (resourceContainer instanceof ProcessingMatrixInputResourceContainer) {
            ProcessingMatrixInputResourceContainer inputResourceContainer = (ProcessingMatrixInputResourceContainer)resourceContainer;
            set = inputResourceContainer.getAllowedTagIds(index);
        } else {
            set = Collections.emptySet();
        }
        this.cachedAllowedAlternatives = set;
        this.input = input;
        this.startY = (Integer)startEndY.getLeft();
        this.endY = (Integer)startEndY.getRight();
    }

    @Override
    public boolean broadcastChanges(Player player) {
        boolean resourceChanged = super.broadcastChanges(player);
        ResourceContainer resourceContainer = this.resourceContainer;
        if (resourceContainer instanceof ProcessingMatrixInputResourceContainer) {
            ProcessingMatrixInputResourceContainer inputResourceContainer = (ProcessingMatrixInputResourceContainer)resourceContainer;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.checkAllowedAlternativesChanged(inputResourceContainer, serverPlayer, resourceChanged);
            }
        }
        return resourceChanged;
    }

    private void checkAllowedAlternativesChanged(ProcessingMatrixInputResourceContainer container, ServerPlayer serverPlayer, boolean resourceChanged) {
        Set<ResourceLocation> currentAllowedAlternatives = container.getAllowedTagIds(this.getContainerSlot());
        if (!currentAllowedAlternatives.equals(this.cachedAllowedAlternatives) || resourceChanged) {
            LOGGER.debug("Re-sending alternatives for resource slot {}", (Object)this.getContainerSlot());
            this.cachedAllowedAlternatives = new HashSet<ResourceLocation>(currentAllowedAlternatives);
            S2CPackets.sendPatternGridAllowedAlternativesUpdate(serverPlayer, this.getContainerSlot(), currentAllowedAlternatives);
        }
    }

    boolean isInput() {
        return this.input;
    }

    public boolean isActive() {
        PatternType patternType = this.patternTypeSupplier.get();
        return patternType == PatternType.PROCESSING && this.y >= this.startY && this.y < this.endY;
    }

    public boolean isHighlightable() {
        return false;
    }

    @Override
    public Component getClickToConfigureAmountHelpTooltip() {
        if (this.input) {
            return CLICK_TO_CONFIGURE_AMOUNT_AND_ALTERNATIVES;
        }
        return super.getClickToConfigureAmountHelpTooltip();
    }
}

