/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.autocrafting.autocrafter;

import com.refinedmods.refinedstorage.common.api.support.network.ConnectionSink;
import com.refinedmods.refinedstorage.common.autocrafting.autocrafter.AutocrafterBlock;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.network.ColoredConnectionStrategy;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

class AutocrafterConnectionStrategy
extends ColoredConnectionStrategy {
    AutocrafterConnectionStrategy(Supplier<BlockState> blockStateProvider, BlockPos origin) {
        super(blockStateProvider, origin);
    }

    @Override
    public void addOutgoingConnections(ConnectionSink sink) {
        Direction myDirection = AbstractDirectionalBlock.tryExtractDirection((BlockState)this.blockStateProvider.get());
        if (myDirection == null) {
            super.addOutgoingConnections(sink);
            return;
        }
        for (Direction direction : Direction.values()) {
            if (direction == myDirection) {
                sink.tryConnectInSameDimension(this.origin.relative(direction), direction.getOpposite(), AutocrafterBlock.class);
                continue;
            }
            sink.tryConnectInSameDimension(this.origin.relative(direction), direction.getOpposite());
        }
    }

    @Override
    public boolean canAcceptIncomingConnection(Direction incomingDirection, BlockState connectingState) {
        if (!this.colorsAllowConnecting(connectingState)) {
            return false;
        }
        Direction myDirection = AbstractDirectionalBlock.tryExtractDirection((BlockState)this.blockStateProvider.get());
        if (myDirection != null) {
            return myDirection != incomingDirection || connectingState.getBlock() instanceof AutocrafterBlock;
        }
        return true;
    }
}

