/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.emi.common;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.RecipeModIngredientConverter;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;

class EmiRecipeModIngredientConverter
implements RecipeModIngredientConverter {
    EmiRecipeModIngredientConverter() {
    }

    public Optional<PlatformResourceKey> convertToResource(Object ingredient) {
        if (ingredient instanceof FluidEmiStack) {
            FluidEmiStack fluid = (FluidEmiStack)ingredient;
            return Optional.of(new FluidResource((Fluid)fluid.getKey(), fluid.getComponentChanges()));
        }
        if (ingredient instanceof ItemEmiStack) {
            ItemEmiStack item = (ItemEmiStack)ingredient;
            return Optional.of(new ItemResource((Item)item.getKey(), item.getComponentChanges()));
        }
        return Optional.empty();
    }

    public Optional<ResourceAmount> convertToResourceAmount(Object ingredient) {
        if (ingredient instanceof FluidEmiStack) {
            FluidEmiStack fluid = (FluidEmiStack)ingredient;
            return Optional.of(new ResourceAmount((ResourceKey)new FluidResource((Fluid)fluid.getKey(), fluid.getComponentChanges()), fluid.getAmount()));
        }
        if (ingredient instanceof ItemEmiStack) {
            ItemEmiStack item = (ItemEmiStack)ingredient;
            return Optional.of(new ResourceAmount((ResourceKey)new ItemResource((Item)item.getKey(), item.getComponentChanges()), item.getAmount()));
        }
        return Optional.empty();
    }

    public Optional<Object> convertToIngredient(PlatformResourceKey resource) {
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            return Optional.of(EmiStack.of((ItemStack)itemResource.toItemStack()));
        }
        if (resource instanceof FluidResource) {
            FluidResource fluidResource = (FluidResource)resource;
            return Optional.of(EmiStack.of((Fluid)fluidResource.fluid(), (DataComponentPatch)fluidResource.components()));
        }
        return Optional.empty();
    }
}

