/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.emi.common;

import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceList;
import com.refinedmods.refinedstorage.api.resource.list.MutableResourceListImpl;
import com.refinedmods.refinedstorage.api.resource.repository.ResourceRepository;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.view.GridResource;
import com.refinedmods.refinedstorage.common.grid.AbstractCraftingGridContainerMenu;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.emi.common.AbstractEmiRecipeHandler;
import com.refinedmods.refinedstorage.emi.common.TransferInput;
import com.refinedmods.refinedstorage.emi.common.TransferInputType;
import com.refinedmods.refinedstorage.emi.common.TransferType;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.runtime.EmiDrawContext;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.ItemLike;

class CraftingGridEmiRecipeHandler<T extends AbstractCraftingGridContainerMenu>
extends AbstractEmiRecipeHandler<T> {
    private static final Component CTRL_CLICK_TO_AUTOCRAFT = Component.translatable((String)"gui.%s.transfer.ctrl_click_to_autocraft".formatted("refinedstorage_emi_integration"));

    CraftingGridEmiRecipeHandler() {
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<T> screen) {
        MutableResourceList available = ((AbstractCraftingGridContainerMenu)screen.getMenu()).getAvailableListForRecipeTransfer();
        return new EmiPlayerInventory(available.copyState().stream().filter(resourceAmount -> resourceAmount.resource() instanceof ItemResource).map(resourceAmount -> EmiStack.of((ItemLike)((ItemResource)resourceAmount.resource()).item(), (DataComponentPatch)((ItemResource)resourceAmount.resource()).components(), (long)resourceAmount.amount())).toList());
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe instanceof EmiCraftingRecipe;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        return true;
    }

    private static TransferInput toTransferInput(ResourceRepository<GridResource> repository, MutableResourceList available, EmiIngredient input) {
        List<ItemResource> possibilities = CraftingGridEmiRecipeHandler.getItems(input);
        for (ItemResource possibility : possibilities) {
            if (available.remove((ResourceKey)possibility, 1L) == null) continue;
            return new TransferInput(TransferInputType.AVAILABLE, null);
        }
        List<ItemResource> autocraftingPossibilities = possibilities.stream().filter(arg_0 -> repository.isSticky(arg_0)).sorted(Comparator.comparingLong(arg_0 -> repository.getAmount(arg_0))).toList();
        if (!autocraftingPossibilities.isEmpty()) {
            return new TransferInput(TransferInputType.AUTOCRAFTABLE, autocraftingPossibilities.getFirst());
        }
        return new TransferInput(TransferInputType.MISSING, null);
    }

    private static List<ItemResource> getItems(EmiIngredient ingredient) {
        return ingredient.getEmiStacks().stream().map(EmiStack::getItemStack).filter(stack -> !stack.isEmpty()).map(ItemResource::ofItemStack).collect(Collectors.toList());
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        MutableResourceList available = ((AbstractCraftingGridContainerMenu)context.getScreenHandler()).getAvailableListForRecipeTransfer();
        List<TransferInput> transferInputs = recipe.getInputs().stream().filter(input -> !input.isEmpty()).map(input -> CraftingGridEmiRecipeHandler.toTransferInput((ResourceRepository<GridResource>)((AbstractCraftingGridContainerMenu)context.getScreenHandler()).getRepository(), available, input)).toList();
        TransferType transferType = this.getTransferType(transferInputs);
        if (transferType.canOpenAutocraftingPreview() && Screen.hasControlDown()) {
            List<ResourceAmount> craftingRequests = CraftingGridEmiRecipeHandler.createCraftingRequests(transferInputs);
            RefinedStorageClientApi.INSTANCE.openAutocraftingPreview(craftingRequests, (Screen)context.getScreen());
            return false;
        }
        List<List> inputs = recipe.getInputs().stream().map(CraftingGridEmiRecipeHandler::getItems).toList();
        ((AbstractCraftingGridContainerMenu)context.getScreenHandler()).transferRecipe(inputs);
        return true;
    }

    public void render(EmiRecipe recipe, EmiCraftContext<T> craftContext, List<Widget> widgets, GuiGraphics draw) {
        EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)draw);
        RenderSystem.enableDepthTest();
        MutableResourceList available = ((AbstractCraftingGridContainerMenu)craftContext.getScreenHandler()).getAvailableListForRecipeTransfer();
        ResourceRepository repository = ((AbstractCraftingGridContainerMenu)craftContext.getScreenHandler()).getRepository();
        for (Widget widget : widgets) {
            if (!(widget instanceof SlotWidget)) continue;
            SlotWidget slotWidget = (SlotWidget)widget;
            EmiIngredient stack = slotWidget.getStack();
            Bounds bounds = slotWidget.getBounds();
            if (slotWidget.getRecipe() != null || stack.isEmpty()) continue;
            TransferInput transferInput = CraftingGridEmiRecipeHandler.toTransferInput((ResourceRepository<GridResource>)repository, available, stack);
            if (transferInput.type() == TransferInputType.MISSING) {
                context.fill(bounds.x(), bounds.y(), bounds.width(), bounds.height(), 0x44FF0000);
                continue;
            }
            if (transferInput.type() != TransferInputType.AUTOCRAFTABLE) continue;
            context.fill(bounds.x(), bounds.y(), bounds.width(), bounds.height(), AUTOCRAFTABLE_COLOR);
        }
    }

    public List<ClientTooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<T> context) {
        MutableResourceList available = ((AbstractCraftingGridContainerMenu)context.getScreenHandler()).getAvailableListForRecipeTransfer();
        List<TransferInput> transferInputs = recipe.getInputs().stream().filter(input -> !input.isEmpty()).map(input -> CraftingGridEmiRecipeHandler.toTransferInput((ResourceRepository<GridResource>)((AbstractCraftingGridContainerMenu)context.getScreenHandler()).getRepository(), available, input)).toList();
        TransferType transferType = this.getTransferType(transferInputs);
        return this.calculateTooltip(transferType);
    }

    private List<ClientTooltipComponent> calculateTooltip(TransferType type) {
        return switch (type) {
            case TransferType.MISSING -> List.of(ClientTooltipComponent.create((FormattedCharSequence)EmiPort.ordered((Component)NOT_ENOUGH_INGREDIENTS)));
            case TransferType.MISSING_BUT_ALL_AUTOCRAFTABLE -> List.of(CraftingGridEmiRecipeHandler.createAutocraftableHint((Component)Component.translatable((String)"gui.%s.transfer.missing_but_all_autocraftable".formatted("refinedstorage_emi_integration"))), HelpClientTooltipComponent.createAlwaysDisplayed((Component)CTRL_CLICK_TO_AUTOCRAFT));
            case TransferType.MISSING_BUT_SOME_AUTOCRAFTABLE -> List.of(CraftingGridEmiRecipeHandler.createAutocraftableHint((Component)Component.translatable((String)"gui.%s.transfer.missing_but_some_autocraftable".formatted("refinedstorage_emi_integration"))), HelpClientTooltipComponent.createAlwaysDisplayed((Component)CTRL_CLICK_TO_AUTOCRAFT));
            default -> Collections.emptyList();
        };
    }

    private TransferType getTransferType(List<TransferInput> transferInputs) {
        if (transferInputs.stream().allMatch(input -> input.type() == TransferInputType.AVAILABLE)) {
            return TransferType.AVAILABLE;
        }
        boolean hasMissing = transferInputs.stream().anyMatch(input -> input.type() == TransferInputType.MISSING);
        boolean hasAutocraftable = transferInputs.stream().anyMatch(input -> input.type() == TransferInputType.AUTOCRAFTABLE);
        if (hasMissing && hasAutocraftable) {
            return TransferType.MISSING_BUT_SOME_AUTOCRAFTABLE;
        }
        if (hasAutocraftable) {
            return TransferType.MISSING_BUT_ALL_AUTOCRAFTABLE;
        }
        return TransferType.MISSING;
    }

    private static List<ResourceAmount> createCraftingRequests(List<TransferInput> transferInputs) {
        MutableResourceListImpl requests = MutableResourceListImpl.orderPreserving();
        for (TransferInput transferInput : transferInputs) {
            if (transferInput.type() != TransferInputType.AUTOCRAFTABLE || transferInput.autocraftableResource() == null) continue;
            requests.add((ResourceKey)transferInput.autocraftableResource(), 1L);
        }
        return requests.copyState().stream().toList();
    }
}

