/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.agriculturehusbandry.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.capability.tile.BigEnergyHandler;
import com.buuz135.industrial.config.machine.agriculturehusbandry.WitherBuilderConfig;
import com.buuz135.industrial.module.ModuleAgricultureHusbandry;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public class WitherBuilderTile
extends IndustrialAreaWorkingTile<WitherBuilderTile> {
    @Save
    private SidedInventoryComponent<WitherBuilderTile> top = (SidedInventoryComponent)new SidedInventoryComponent("wither_skulls", 64, 25, 3, 0).setColor(DyeColor.BLACK).setInputFilter((itemStack, integer) -> itemStack.getItem().equals(Items.WITHER_SKELETON_SKULL)).setSlotLimit(1).setComponentHarness((IComponentHarness)this);
    @Save
    private SidedInventoryComponent<WitherBuilderTile> middle;

    public WitherBuilderTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleAgricultureHusbandry.WITHER_BUILDER, RangeManager.RangeType.TOP_UP, true, WitherBuilderConfig.powerPerOperation, blockPos, blockState);
        this.addInventory((InventoryComponent)this.top);
        this.middle = (SidedInventoryComponent)new SidedInventoryComponent("soulsand", 64, 43, 4, 1).setColor(DyeColor.BROWN).setInputFilter((itemStack, integer) -> itemStack.getItem().equals(Blocks.SOUL_SAND.asItem())).setSlotPosition(integer -> {
            if (integer == 3) {
                return Pair.of((Object)18, (Object)18);
            }
            return Pair.of((Object)(18 * (integer % 3)), (Object)(18 * (integer / 3)));
        }).setSlotLimit(1).setComponentHarness((IComponentHarness)this);
        this.addInventory((InventoryComponent)this.middle);
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        int slot;
        if (!this.hasEnergy(WitherBuilderConfig.powerPerOperation) || !BlockUtils.canBlockBeBroken(this.level, this.worldPosition, this.getUuid()) || this.level.getDifficulty() == Difficulty.PEACEFUL) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        if (this.level.getEntitiesOfClass(WitherBoss.class, this.getWorkingArea().bounds()).size() > 5) {
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        for (BlockPos blockPos : BlockUtils.getBlockPosInAABB(this.getWorkingArea().bounds())) {
            if (this.level.getBlockState(blockPos).isAir()) continue;
            return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
        }
        for (ItemStackHandler handler : new ItemStackHandler[]{this.top, this.middle}) {
            for (slot = 0; slot < handler.getSlots(); ++slot) {
                if (!handler.getStackInSlot(slot).isEmpty()) continue;
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
            }
        }
        for (ItemStackHandler handler : new ItemStackHandler[]{this.top, this.middle}) {
            for (slot = 0; slot < handler.getSlots(); ++slot) {
                handler.getStackInSlot(slot).shrink(1);
            }
        }
        WitherBoss wither = (WitherBoss)EntityType.WITHER.create(this.level);
        BlockPos pos = this.worldPosition.offset(0, 2, 0);
        wither.moveTo((double)pos.getX() + 0.5, (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
        wither.yBodyRot = this.getFacingDirection().getAxis() != Direction.Axis.X ? 0.0f : 90.0f;
        wither.makeInvulnerable();
        this.level.addFreshEntity((Entity)wither);
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, WitherBuilderConfig.powerPerOperation);
    }

    @Override
    public VoxelShape getWorkingArea() {
        return new RangeManager(this.worldPosition, this.getFacingDirection(), RangeManager.RangeType.TOP_UP){

            @Override
            public AABB getBox() {
                if (WitherBuilderTile.this.getFacingDirection() == Direction.EAST || WitherBuilderTile.this.getFacingDirection() == Direction.WEST) {
                    return super.getBox().move(new BlockPos(0, 1, 0)).inflate(0.0, 1.0, 1.0);
                }
                return super.getBox().move(new BlockPos(0, 1, 0)).inflate(1.0, 1.0, 0.0);
            }
        }.get(0);
    }

    @Nonnull
    public WitherBuilderTile getSelf() {
        return this;
    }

    @Nonnull
    protected EnergyStorageComponent<WitherBuilderTile> createEnergyStorage() {
        return new BigEnergyHandler<WitherBuilderTile>(WitherBuilderConfig.maxStoredPower, 10, 20){

            @Override
            public void sync() {
                WitherBuilderTile.this.syncObject(WitherBuilderTile.this.getEnergyStorage());
            }
        };
    }

    @Override
    public int getMaxProgress() {
        return WitherBuilderConfig.maxProgress;
    }

    public ItemStack getDefaultOrFind(int i, ItemStackHandler handler, ItemStack filter) {
        if (ItemStack.isSameItem((ItemStack)handler.getStackInSlot(i), (ItemStack)filter)) {
            return handler.getStackInSlot(i);
        }
        for (ItemStackHandler h : new ItemStackHandler[]{this.top, this.middle}) {
            for (int s = 0; s < h.getSlots(); ++s) {
                if (!ItemStack.isSameItem((ItemStack)h.getStackInSlot(s), (ItemStack)filter)) continue;
                return h.getStackInSlot(s);
            }
        }
        return ItemStack.EMPTY;
    }
}

