/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.util;

import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.parts.IPart;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.networking.CableBusBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FCUtil {
    public static void replaceTile(Level world, BlockPos pos, BlockEntity oldTile, BlockEntity newTile, BlockState newBlock) {
        CompoundTag contents = oldTile.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
        world.removeBlockEntity(pos);
        world.removeBlock(pos, false);
        world.setBlock(pos, newBlock, 3);
        world.setBlockEntity(newTile);
        newTile.loadWithComponents(contents, (HolderLookup.Provider)world.registryAccess());
        if (newTile instanceof AEBaseBlockEntity) {
            AEBaseBlockEntity aeTile = (AEBaseBlockEntity)newTile;
            aeTile.markForUpdate();
        } else {
            newTile.setChanged();
        }
    }

    public static boolean ejectInv(Level world, BlockPos pos, InternalInventory inv, Set<Direction> outputSides, Predicate<? super BlockEntity> shouldIgnore) {
        for (Direction dir : outputSides) {
            ItemTransfer target;
            BlockEntity te = world.getBlockEntity(pos.relative(dir));
            if (te == null || shouldIgnore.test((BlockEntity)te) || (target = InternalInventory.wrapExternal((Level)world, (BlockPos)pos.relative(dir), (Direction)dir.getOpposite())) == null) continue;
            int startItems = inv.getStackInSlot(0).getCount();
            inv.insertItem(0, target.addItems(inv.extractItem(0, 64, false)), false);
            int endItems = inv.getStackInSlot(0).getCount();
            if (startItems == endItems) continue;
            return true;
        }
        return false;
    }

    public static int speedCardMap(int card) {
        return FCUtil.speedCardMap(card, 1);
    }

    public static int speedCardMap(int card, int multi) {
        return multi * (switch (card) {
            default -> 2;
            case 1 -> 3;
            case 2 -> 5;
            case 3 -> 10;
            case 4 -> 50;
        });
    }

    public static String[] trimSplit(String str) {
        String[] sp = str.split(",");
        for (int i = 0; i < sp.length; ++i) {
            sp[i] = sp[i].trim();
        }
        return sp;
    }

    public static <E extends Enum<E>> StreamCodec<RegistryFriendlyByteBuf, E> enumStreamCodec(Class<E> clazz) {
        return StreamCodec.of(FriendlyByteBuf::writeEnum, buf -> buf.readEnum(clazz));
    }

    @Nullable
    public static <T> T findDevice(Class<T> clazz, Level world, BlockPos pos, Vec3 clicked) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (clazz.isInstance(tile)) {
            return clazz.cast(tile);
        }
        if (tile instanceof CableBusBlockEntity) {
            CableBusBlockEntity cable = (CableBusBlockEntity)tile;
            Vec3 hitInBlock = new Vec3(clicked.x - (double)pos.getX(), clicked.y - (double)pos.getY(), clicked.z - (double)pos.getZ());
            IPart part = cable.getCableBus().selectPartLocal((Vec3)hitInBlock).part;
            if (clazz.isInstance(part)) {
                return clazz.cast(part);
            }
        }
        return null;
    }

    public static List<String> tokenize(String text) {
        if (text.isBlank()) {
            return List.of();
        }
        text = text.trim().toLowerCase();
        ArrayList<String> tokens = new ArrayList<String>();
        for (String token : text.split(" ")) {
            if (token.isBlank()) continue;
            tokens.add(token.trim());
        }
        return tokens;
    }

    public static boolean compareTokens(List<String> filter, List<String> target) {
        for (int p = 0; p <= target.size() - filter.size(); ++p) {
            int q = p;
            int f = 0;
            while (q < target.size() && f < filter.size()) {
                String ft;
                String tt = target.get(q);
                if (tt.contains(ft = filter.get(f))) {
                    ++q;
                    ++f;
                    continue;
                }
                ++q;
            }
            if (f < filter.size()) continue;
            return true;
        }
        return false;
    }
}

