/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.items.tools;

import appeng.api.implementations.menuobjects.IMenuItem;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.stacks.GenericStack;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.items.AEBaseItem;
import appeng.menu.MenuOpener;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import com.glodblock.github.extendedae.common.EAESingletons;
import com.glodblock.github.extendedae.common.me.itemhost.HostConfigModifier;
import com.glodblock.github.extendedae.container.ContainerConfigModifier;
import com.glodblock.github.extendedae.util.FCUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConfigModifier
extends AEBaseItem
implements IMenuItem {
    public ItemConfigModifier() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player p, @NotNull InteractionHand hand) {
        if (!level.isClientSide()) {
            MenuOpener.open(ContainerConfigModifier.TYPE, (Player)p, (MenuHostLocator)MenuLocators.forHand((Player)p, (InteractionHand)hand));
        }
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)p.getItemInHand(hand));
    }

    @Nonnull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, @NotNull UseOnContext context) {
        Level world = context.getLevel();
        Player player = context.getPlayer();
        IConfigInvHost device = FCUtil.findDevice(IConfigInvHost.class, world, context.getClickedPos(), context.getClickLocation());
        ConfigSettings settings = (ConfigSettings)stack.getOrDefault(EAESingletons.MODIFIER_CONFIG_SETTINGS, (Object)ConfigSettings.DEFAULT);
        if (device != null) {
            GenericStackInv config = device.getConfig();
            int min = config.getMode() == GenericStackInv.Mode.CONFIG_TYPES ? 0 : 1;
            for (int slot = 0; slot < config.size(); ++slot) {
                GenericStack configStack = config.getStack(slot);
                if (configStack == null) continue;
                long amt = settings.modify(configStack.amount(), min, config.getMaxAmount(configStack.what()));
                if (amt < 0L) {
                    config.setStack(slot, null);
                    continue;
                }
                config.setStack(slot, new GenericStack(configStack.what(), amt));
            }
            if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.config_modifier.success", (Object[])new Object[]{this.findName(device)}), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private Component findName(Object obj) {
        if (obj instanceof Nameable) {
            Nameable name = (Nameable)obj;
            return name.getDisplayName();
        }
        if (obj instanceof BlockEntity) {
            BlockEntity te = (BlockEntity)obj;
            return te.getBlockState().getBlock().getName();
        }
        return Component.literal((String)obj.getClass().getSimpleName());
    }

    @Nullable
    public ItemMenuHost<?> getMenuHost(Player player, ItemMenuHostLocator locator, @Nullable BlockHitResult hitResult) {
        return new HostConfigModifier(this, player, locator);
    }

    public record ConfigSettings(Mode mode, long data) {
        public static ConfigSettings DEFAULT = new ConfigSettings(Mode.MUL, 1L);
        public static final Codec<ConfigSettings> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Mode.CODEC.fieldOf("mode").forGetter(o -> o.mode), (App)Codec.LONG.fieldOf("data").forGetter(o -> o.data)).apply((Applicative)builder, ConfigSettings::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConfigSettings> STREAM_CODEC = StreamCodec.composite(Mode.STREAM_CODEC, o -> o.mode, (StreamCodec)ByteBufCodecs.VAR_LONG, o -> o.data, ConfigSettings::new);

        public long modify(long value, long min, long max) {
            return switch (this.mode.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Math.min(value + this.data, max);
                case 1 -> Math.max(value - this.data, min);
                case 2 -> Math.min(value * this.data, max);
                case 3 -> Math.max(value / Math.max(this.data, 1L), min);
                case 4 -> max;
                case 5 -> min;
                case 6 -> Math.clamp(this.data, min, max);
                case 7 -> -1L;
            };
        }

        public static enum Mode implements StringRepresentable
        {
            ADD,
            SUB,
            MUL,
            DIV,
            MAX,
            MIN,
            SET,
            RMV;

            static final Codec<Mode> CODEC;
            static final StreamCodec<RegistryFriendlyByteBuf, Mode> STREAM_CODEC;

            @NotNull
            public String getSerializedName() {
                return this.name().toLowerCase(Locale.US);
            }

            public Mode getNext() {
                return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
            }

            static {
                CODEC = StringRepresentable.fromEnum(Mode::values);
                STREAM_CODEC = FCUtil.enumStreamCodec(Mode.class);
            }
        }
    }
}

