/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.client.gui;

import appeng.api.config.YesNo;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.Scrollbar;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.core.network.serverbound.InventoryActionPacket;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.helpers.InventoryAction;
import appeng.menu.AEBaseMenu;
import appeng.util.inv.AppEngInternalInventory;
import com.glodblock.github.extendedae.client.button.ActionEPPButton;
import com.glodblock.github.extendedae.client.button.CycleEPPButton;
import com.glodblock.github.extendedae.client.gui.widget.AssemblerMatrixSlot;
import com.glodblock.github.extendedae.container.ContainerAssemblerMatrix;
import com.glodblock.github.extendedae.network.EAENetworkHandler;
import com.glodblock.github.extendedae.network.packet.CEAEGenericPacket;
import com.glodblock.github.extendedae.util.FCUtil;
import com.glodblock.github.glodium.network.packet.IMessage;
import com.glodblock.github.glodium.network.packet.sync.ActionMap;
import com.glodblock.github.glodium.network.packet.sync.IActionHolder;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class GuiAssemblerMatrix
extends AEBaseScreen<ContainerAssemblerMatrix>
implements IActionHolder {
    private static final int ROW_HEIGHT = 18;
    private static final int GUI_PADDING_X = 8;
    private static final int SLOT_SIZE = 18;
    private static final ResourceLocation BG = AppEng.makeId((String)"textures/guis/assembler_matrix.png");
    private static final Rect2i EMPTY_ROW1 = new Rect2i(0, 203, 160, 16);
    private static final Rect2i EMPTY_ROW2 = new Rect2i(0, 219, 160, 18);
    private final ActionMap actions = ActionMap.create();
    private final Scrollbar scrollbar;
    private final Long2ReferenceMap<PatternInfo> infos = new Long2ReferenceOpenHashMap();
    private final Set<ItemStack> matchedStack = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<ItemStack>(this){

        public int hashCode(ItemStack o) {
            return ItemStack.hashItemAndComponents((ItemStack)o);
        }

        public boolean equals(ItemStack a, ItemStack b) {
            return a == b || a != null && b != null && ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
        }
    });
    private final ArrayList<PatternRow> rows = new ArrayList();
    private final AETextField searchField;
    private int runningThreads = 0;
    private final CycleEPPButton patternShowBtn = new CycleEPPButton();

    public GuiAssemblerMatrix(ContainerAssemblerMatrix menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        this.scrollbar = this.widgets.addScrollBar("scrollbar", Scrollbar.BIG);
        this.searchField = this.widgets.addTextField("search");
        this.searchField.setResponder(str -> this.refreshList());
        this.searchField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
        this.searchField.setTooltipMessage(Collections.singletonList(Component.translatable((String)"gui.extendedae.assembler_matrix.tooltip")));
        this.actions.put("running_update", o -> {
            this.runningThreads = (Integer)o.get(0);
        });
        this.actions.put("pattern_mode_update", o -> this.patternShowBtn.setState((Integer)o.get(0)));
        ActionEPPButton cancel = new ActionEPPButton(b -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("cancel")), Icon.CLEAR);
        cancel.setMessage((Component)Component.translatable((String)"gui.extendedae.assembler_matrix.cancel"));
        this.patternShowBtn.addActionPair(Icon.PATTERN_ACCESS_SHOW, (Component)GuiText.PatternAccessTerminalHint.text(), b -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("pattern_mode", YesNo.NO.name())));
        this.patternShowBtn.addActionPair(Icon.PATTERN_ACCESS_HIDE, (Component)GuiText.PatternAccessTerminalHint.text(), b -> EAENetworkHandler.INSTANCE.sendToServer((IMessage)new CEAEGenericPacket("pattern_mode", YesNo.YES.name())));
        this.addToLeftToolbar((Button)cancel);
        this.addToLeftToolbar((Button)this.patternShowBtn);
    }

    public void init() {
        super.init();
        this.setInitialFocus((GuiEventListener)this.searchField);
        this.resetScrollbar();
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (btn == 1 && this.searchField.isMouseOver(xCoord, yCoord)) {
            this.searchField.setValue("");
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        ((ContainerAssemblerMatrix)this.menu).slots.removeIf(slot -> slot instanceof AssemblerMatrixSlot);
        int textColor = this.style.getColor(PaletteColor.DEFAULT_TEXT_COLOR).toARGB();
        int scrollLevel = this.scrollbar.getCurrentScroll();
        for (int i = 0; i < 4; ++i) {
            if (scrollLevel + i >= this.rows.size()) continue;
            PatternRow row = this.rows.get(scrollLevel + i);
            for (int col = 0; col < row.slots; ++col) {
                AssemblerMatrixSlot slot2 = new AssemblerMatrixSlot(row.inventory, col, row.offset, row.id, col * 18 + 8, (i + 1) * 18 + 13);
                ((ContainerAssemblerMatrix)this.menu).slots.add((Object)slot2);
                if (this.searchField.getValue().isEmpty()) continue;
                if (this.matchedStack.contains(slot2.getItem())) {
                    this.fillRect(guiGraphics, new Rect2i(slot2.x, slot2.y, 16, 16), -1979646208);
                    continue;
                }
                this.fillRect(guiGraphics, new Rect2i(slot2.x, slot2.y, 16, 16), 0x6A000000);
            }
        }
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.extendedae.assembler_matrix.threads", (Object[])new Object[]{this.runningThreads}), 80, 19, textColor, false);
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        int size;
        super.drawBG(guiGraphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        if (size < 4) {
            boolean first = true;
            for (size = this.rows.size(); size < 4; ++size) {
                if (first) {
                    this.blit(guiGraphics, offsetX + 8, offsetY + 18 * size + 29 + 2, EMPTY_ROW1);
                    first = false;
                    continue;
                }
                this.blit(guiGraphics, offsetX + 8, offsetY + 18 * size + 29, EMPTY_ROW2);
            }
        }
    }

    protected void slotClicked(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof AssemblerMatrixSlot) {
            AssemblerMatrixSlot machineSlot = (AssemblerMatrixSlot)slot;
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    break;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (!this.getPlayer().getAbilities().instabuild) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                InventoryActionPacket p = new InventoryActionPacket(action, machineSlot.getActuallySlot(), machineSlot.getID());
                PacketDistributor.sendToServer((CustomPacketPayload)p, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            return;
        }
        super.slotClicked(slot, slotIdx, mouseButton, clickType);
    }

    private void blit(GuiGraphics guiGraphics, int offsetX, int offsetY, Rect2i srcRect) {
        guiGraphics.blit(BG, offsetX, offsetY, srcRect.getX(), srcRect.getY(), srcRect.getWidth(), srcRect.getHeight());
    }

    private void resetScrollbar() {
        this.scrollbar.setHeight(70);
        this.scrollbar.setRange(0, this.rows.size() - 4, 2);
    }

    public void receiveUpdate(long id, Int2ObjectMap<ItemStack> updateMap) {
        PatternInfo info = (PatternInfo)this.infos.computeIfAbsent(id, PatternInfo::new);
        for (Int2ObjectMap.Entry entry : updateMap.int2ObjectEntrySet()) {
            PatternRow row = info.getRowBySlot(entry.getIntKey());
            row.setItemByInvSlot(entry.getIntKey(), (ItemStack)entry.getValue());
        }
        this.refreshList();
    }

    private void refreshList() {
        this.rows.clear();
        this.matchedStack.clear();
        for (long id : this.getSortedInfo()) {
            PatternInfo info = (PatternInfo)this.infos.get(id);
            for (PatternRow row : info.internalRows) {
                if (!this.filterRows(row)) continue;
                this.rows.add(row);
            }
        }
        this.resetScrollbar();
    }

    private boolean filterRows(PatternRow row) {
        String filter = this.searchField.getValue();
        if (filter.isBlank()) {
            return true;
        }
        List<String> token = FCUtil.tokenize(filter);
        boolean anyMatch = false;
        for (ItemStack stack : row.inventory) {
            if (!this.itemStackMatchesSearchTerm(stack, token)) continue;
            anyMatch = true;
        }
        return anyMatch;
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, List<String> searchTokens) {
        IPatternDetails result = null;
        if (itemStack.getItem() instanceof EncodedPatternItem) {
            result = PatternDetailsHelper.decodePattern((ItemStack)itemStack, (Level)((ContainerAssemblerMatrix)this.menu).getPlayer().level());
        }
        if (result == null) {
            return false;
        }
        for (GenericStack item : result.getOutputs()) {
            List<String> nameTokens;
            if (item == null || !FCUtil.compareTokens(searchTokens, nameTokens = FCUtil.tokenize(item.what().getDisplayName().getString()))) continue;
            this.matchedStack.add(itemStack);
            return true;
        }
        for (IPatternDetails.IInput item : result.getInputs()) {
            List<String> nameTokens;
            if (item == null || !FCUtil.compareTokens(searchTokens, nameTokens = FCUtil.tokenize(item.getPossibleInputs()[0].what().getDisplayName().getString()))) continue;
            this.matchedStack.add(itemStack);
            return true;
        }
        return false;
    }

    private long[] getSortedInfo() {
        return this.infos.keySet().longStream().sorted().toArray();
    }

    @NotNull
    public ActionMap getActionMap() {
        return this.actions;
    }

    private static class PatternRow {
        private final AppEngInternalInventory inventory;
        private final long id;
        private final int offset;
        private final int slots;

        PatternRow(long patternID, int offset, int slots) {
            this.id = patternID;
            this.offset = offset;
            this.slots = slots;
            this.inventory = new AppEngInternalInventory(slots);
        }

        void setItemByInvSlot(int slot, ItemStack stack) {
            this.inventory.setItemDirect(slot - this.offset, stack);
        }
    }

    private static class PatternInfo {
        private final List<PatternRow> internalRows = new ArrayList<PatternRow>();

        PatternInfo(long id) {
            int left = 36;
            int offset = 0;
            do {
                this.internalRows.add(new PatternRow(id, offset, Math.min(left, 9)));
                offset += 9;
            } while ((left -= 9) > 0);
        }

        PatternRow getRowBySlot(int slot) {
            return this.internalRows.get(slot / 9);
        }
    }
}

