/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.packingtape.tape;

import dev.gigaherz.packingtape.ConfigValues;
import dev.gigaherz.packingtape.PackingTapeMod;
import dev.gigaherz.packingtape.tape.ContainedBlockData;
import dev.gigaherz.packingtape.tape.PackagedBlockEntity;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PackagedBlock
extends Block
implements EntityBlock {
    private static Logger LOGGER = LogManager.getLogger();
    public static final BooleanProperty UNPACKING = BooleanProperty.create((String)"unpacking");

    public PackagedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)UNPACKING, (Comparable)Boolean.valueOf(false)));
    }

    @Deprecated
    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return (Boolean)state.getValue((Property)UNPACKING);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PackagedBlockEntity(pos, state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UNPACKING});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if (player instanceof FakePlayer || player.level().isClientSide && ClientKeys.isStrictPicking(player)) {
            return new ItemStack((ItemLike)this.asItem(), 1);
        }
        return new ItemStack((ItemLike)PackingTapeMod.TAPE.get(), 1);
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof PackagedBlockEntity) {
            PackagedBlockEntity packaged = (PackagedBlockEntity)te;
            if (!world.isClientSide && player.isCreative() && !packaged.isEmpty()) {
                ItemStack stack = packaged.getPackedStack();
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
                itemEntity.setDefaultPickUpDelay();
                world.addFreshEntity((Entity)itemEntity);
            }
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            if (!placer.isShiftKeyDown()) {
                PackagedBlockEntity te = (PackagedBlockEntity)worldIn.getBlockEntity(pos);
                assert (te != null);
                Direction allDirection = Direction.getNearest((Vec3)player.getLookAngle()).getOpposite();
                Direction horizontalDirection = player.getDirection().getOpposite();
                te.setPreferredDirection(allDirection, horizontalDirection);
            }
        }
        super.setPlacedBy(worldIn, pos, state, placer, stack);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.use(level, pos, player).result();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.use(level, pos, player);
    }

    public ItemInteractionResult use(Level level, BlockPos pos, Player player) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (!(te instanceof PackagedBlockEntity)) {
            return this.displayBlockMissingError(level, pos);
        }
        PackagedBlockEntity packagedBlock = (PackagedBlockEntity)te;
        BlockState newState = packagedBlock.getContainedBlockState();
        CompoundTag entityData = packagedBlock.getContainedTile();
        Direction preferredAll = packagedBlock.getPreferredDirectionAll();
        Direction preferredHorizontal = packagedBlock.getPreferredDirectionHorizontal();
        if (newState == null || entityData == null) {
            return this.displayBlockMissingError(level, pos);
        }
        EnumProperty<Direction> facing = PackagedBlock.findFacingProperty(newState);
        if (facing != null) {
            if (preferredAll != null && facing.getPossibleValues().contains(preferredAll)) {
                newState = (BlockState)newState.setValue(facing, (Comparable)preferredAll);
            } else if (preferredHorizontal != null && facing.getPossibleValues().contains(preferredHorizontal)) {
                newState = (BlockState)newState.setValue(facing, (Comparable)preferredHorizontal);
            }
        }
        if (facing != null && !player.isShiftKeyDown() && newState.getBlock() instanceof ChestBlock && newState.hasProperty((Property)ChestBlock.TYPE)) {
            Direction chestFacing = (Direction)newState.getValue(facing);
            Direction left = chestFacing.getClockWise();
            Direction right = chestFacing.getCounterClockWise();
            BlockState leftState = level.getBlockState(pos.relative(left));
            if (leftState.getBlock() == newState.getBlock() && leftState.getValue((Property)ChestBlock.TYPE) == ChestType.SINGLE && leftState.getValue((Property)ChestBlock.FACING) == chestFacing) {
                level.setBlockAndUpdate(pos.relative(left), (BlockState)leftState.setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.RIGHT));
                newState = (BlockState)newState.setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.LEFT);
            } else {
                BlockState rightState = level.getBlockState(pos.relative(right));
                if (rightState.getBlock() == newState.getBlock() && rightState.getValue((Property)ChestBlock.TYPE) == ChestType.SINGLE && rightState.getValue((Property)ChestBlock.FACING) == chestFacing) {
                    level.setBlockAndUpdate(pos.relative(right), (BlockState)rightState.setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.LEFT));
                    newState = (BlockState)newState.setValue((Property)ChestBlock.TYPE, (Comparable)ChestType.RIGHT);
                }
            }
        }
        level.removeBlockEntity(pos);
        level.setBlockAndUpdate(pos, newState);
        PackagedBlock.setTileEntityNBT(level, player, pos, entityData);
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public static EnumProperty<Direction> findFacingProperty(BlockState newState) {
        EnumProperty facing = null;
        for (Property prop : newState.getProperties()) {
            if (!prop.getName().equalsIgnoreCase("facing") && !prop.getName().equalsIgnoreCase("rotation") || !(prop instanceof EnumProperty) || prop.getValueClass() != Direction.class) continue;
            facing = (EnumProperty)prop;
            break;
        }
        return facing;
    }

    private ItemInteractionResult displayBlockMissingError(Level world, BlockPos pos) {
        LOGGER.error("The packaged block does not contain valid data");
        world.addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 0.0, 0.0, 0.0);
        world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        return ItemInteractionResult.CONSUME;
    }

    public static void setTileEntityNBT(Level level, @javax.annotation.Nullable Player player, BlockPos pos, CompoundTag compoundtag) {
        if (level.isClientSide) {
            return;
        }
        MinecraftServer minecraftserver = level.getServer();
        if (minecraftserver == null) {
            return;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity != null) {
            if (blockentity.onlyOpCanSetNbt() && player != null && !player.canUseGameMasterBlocks() && !ConfigValues.isBlockEntityWhitelisted(blockentity)) {
                return;
            }
            CompoundTag current = blockentity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            CompoundTag original = current.copy();
            current.merge(compoundtag);
            if (!current.equals((Object)original)) {
                blockentity.loadWithComponents(current, (HolderLookup.Provider)level.registryAccess());
                blockentity.setChanged();
            }
        }
    }

    private static Component makeError(String detail) {
        return Component.translatable((String)"text.packingtape.packaged.missing_data", (Object[])new Object[]{Component.translatable((String)detail)});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag advanced) {
        ContainedBlockData data = (ContainedBlockData)stack.get(PackingTapeMod.CONTAINED_BLOCK);
        if (data == null) {
            tooltip.add(PackagedBlock.makeError("text.packingtape.packaged.no_nbt"));
            return;
        }
        Block block = data.getBlock();
        ResourceLocation blockName = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (block == Blocks.AIR) {
            tooltip.add((Component)Component.translatable((String)"text.packingtape.packaged.unknown_block"));
            tooltip.add((Component)Component.literal((String)("  " + String.valueOf(blockName))));
            return;
        }
        Item item = block.asItem();
        if (item == Items.AIR && (item = (Item)BuiltInRegistries.ITEM.get(blockName)) == Items.AIR) {
            tooltip.add((Component)Component.translatable((String)"text.packingtape.packaged.no_item"));
            tooltip.add((Component)Component.literal((String)("  " + String.valueOf(blockName))));
            return;
        }
        ItemStack stack1 = new ItemStack((ItemLike)item, 1);
        tooltip.add((Component)Component.translatable((String)"text.packingtape.packaged.contains", (Object[])new Object[]{stack1.getHoverName()}));
    }

    private static class ClientKeys {
        private ClientKeys() {
        }

        public static boolean isStrictPicking(Player player) {
            return Screen.hasShiftDown() || player.getAbilities().instabuild && Screen.hasControlDown();
        }
    }
}

