/*
 * Decompiled with CFR 0.152.
 */
package vapourdrive.vapourware.shared.base;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import vapourdrive.vapourware.VapourWare;
import vapourdrive.vapourware.setup.Registration;
import vapourdrive.vapourware.shared.base.ITickingContainer;

public abstract class AbstractBaseContainerBlock
extends BaseEntityBlock {
    protected AbstractBaseContainerBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getItemInHand(hand).is(Registration.HANDYMAN_WRENCH.get())) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!level.isClientSide) {
            this.openContainer(level, pos, player);
        }
        return ItemInteractionResult.CONSUME;
    }

    protected void openContainer(Level level, @NotNull BlockPos pos, @NotNull Player player) {
    }

    public void attack(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player) {
        VapourWare.debugLog(player.getMainHandItem().toString());
        if (player.getMainHandItem().is(Registration.HANDYMAN_WRENCH.get())) {
            SoundEvent sound = level.getBlockState(pos).getSoundType((LevelReader)level, pos, (Entity)player).getPlaceSound();
            this.disassemble(state, level, pos);
            level.playSound(player, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 0.5f, 1.0f - level.getRandom().nextFloat() * 0.3f);
            level.playSound(player, pos, sound, SoundSource.BLOCKS, 0.8f, 1.0f + level.getRandom().nextFloat() * 0.3f);
            VapourWare.debugLog("in block disassembly call from attack field");
        }
        VapourWare.debugLog("in block disassembly call from attack field, not with wrench");
    }

    public boolean sneakWrenchMachine(Player player, Level level, BlockPos pos) {
        return false;
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        drops.clear();
        BlockEntity blockEntity = (BlockEntity)builder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof ITickingContainer) {
            ITickingContainer be = (ITickingContainer)blockEntity;
            ItemStack self = this.putAdditionalInfo(new ItemStack((ItemLike)this), blockEntity);
            drops.add(self);
            for (int i = 0; i < be.getItemHandler(null).getSlots(); ++i) {
                drops.add(be.getItemHandler(null).getStackInSlot(i));
            }
        }
        return drops;
    }

    public void disassemble(BlockState state, @NotNull Level level, @NotNull BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ITickingContainer) {
            ITickingContainer be = (ITickingContainer)blockEntity;
            ItemStack self = this.putAdditionalInfo(new ItemStack((ItemLike)this), blockEntity);
            Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)self);
            for (int i = 0; i < be.getItemHandler(null).getSlots(); ++i) {
                Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)be.getItemHandler(null).getStackInSlot(i));
            }
        }
        this.onRemove(state, level, blockPos, Blocks.AIR.defaultBlockState(), false);
        level.setBlockAndUpdate(blockPos, Blocks.AIR.defaultBlockState());
        VapourWare.debugLog("in th end of the disassembly");
    }

    protected ItemStack putAdditionalInfo(ItemStack stack, BlockEntity blockEntity) {
        return stack;
    }

    protected static void dropContents(Level world, BlockPos blockPos, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            Containers.dropItemStack((Level)world, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)handler.getStackInSlot(i));
        }
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }
}

