/*
 * Decompiled with CFR 0.152.
 */
package artifacts.equipment;

import artifacts.component.ability.EnchantmentLevelModifiers;
import artifacts.component.ability.EquipmentAbility;
import artifacts.equipment.EquipmentSlotManager;
import artifacts.registry.ModDataComponents;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class EquipmentHelper {
    public static boolean hasComponent(DataComponentType<?> type, @Nullable LivingEntity entity) {
        return EquipmentHelper.reduceComponents(type, entity, false, (prefix, stack, component) -> true);
    }

    public static boolean hasAbilityActive(DataComponentType<? extends EquipmentAbility> type, @Nullable LivingEntity entity, boolean skipItemsOnCooldown) {
        return EquipmentHelper.hasAbilityActive(type, entity, skipItemsOnCooldown, ability -> true);
    }

    public static <A extends EquipmentAbility> boolean hasAbilityActive(DataComponentType<A> type, @Nullable LivingEntity entity, boolean skipItemsOnCooldown, Predicate<A> predicate) {
        if (entity == null) {
            return false;
        }
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, false, (ability, stack, b) -> b != false || ability.isNonCosmetic() && predicate.test(ability));
    }

    public static int getEnchantmentLevelIncrease(ResourceKey<Enchantment> enchantment, LivingEntity entity) {
        return EquipmentHelper.sumInt(ModDataComponents.ENCHANTMENT_LEVEL_MODIFIERS.get(), entity, ability -> {
            int amount = 0;
            for (EnchantmentLevelModifiers.Entry entry : ability.entries()) {
                if (!entry.enchantment().equals((Object)enchantment)) continue;
                amount += ((Integer)entry.amount().get()).intValue();
            }
            return amount;
        }, true);
    }

    public static <A extends EquipmentAbility> int sumInt(DataComponentType<A> type, LivingEntity entity, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, 0, (ability, stack, i) -> i + (Integer)f.apply(ability));
    }

    public static <A extends EquipmentAbility> double maxDouble(DataComponentType<A> type, LivingEntity entity, Function<A, Double> f, boolean skipItemsOnCooldown) {
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, 0.0, (ability, stack, d) -> Math.max(d, (Double)f.apply(ability)));
    }

    public static <A extends EquipmentAbility> double minDouble(DataComponentType<A> type, LivingEntity entity, double init, Function<A, Double> f, boolean skipItemsOnCooldown) {
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, init, (ability, stack, d) -> Math.min(d, (Double)f.apply(ability)));
    }

    public static <A extends EquipmentAbility> int maxInt(DataComponentType<A> type, LivingEntity entity, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, 0, (ability, stack, d) -> Math.max(d, (Integer)f.apply(ability)));
    }

    public static <A extends EquipmentAbility> int minInt(DataComponentType<A> type, LivingEntity entity, int init, Function<A, Integer> f, boolean skipItemsOnCooldown) {
        return EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, true, init, (ability, stack, d) -> Math.min(d, (Integer)f.apply(ability)));
    }

    public static <A extends EquipmentAbility> void iterateAbilities(DataComponentType<A> type, LivingEntity entity, boolean skipItemsOnCooldown, boolean skipDisabledItems, BiConsumer<A, ItemStack> consumer) {
        EquipmentHelper.reduceAbilities(type, entity, skipItemsOnCooldown, skipDisabledItems, Unit.INSTANCE, (ability, stack, unit) -> {
            consumer.accept((Object)ability, (ItemStack)stack);
            return Unit.INSTANCE;
        });
    }

    public static <ABILITY extends EquipmentAbility, ACC> ACC reduceAbilities(DataComponentType<ABILITY> type, LivingEntity entity, boolean skipItemsOnCooldown, boolean skipDisabledItems, ACC init, TriFunction<ABILITY, ItemStack, ACC, ACC> f) {
        return (ACC)EquipmentHelper.reduceEquipment(entity, init, (stack, init_) -> {
            EquipmentAbility ability = (EquipmentAbility)stack.get(type);
            if (ability != null) {
                boolean checkCosmetic;
                Player player;
                boolean checkCooldown = !skipItemsOnCooldown || !(entity instanceof Player) || !(player = (Player)entity).getCooldowns().isOnCooldown(stack.getItem());
                boolean checkDisabled = !skipDisabledItems || !stack.has(ModDataComponents.DISABLED_BY_TOGGLE.get());
                boolean bl = checkCosmetic = !skipDisabledItems || ability.isNonCosmetic();
                if (checkCooldown && checkDisabled && checkCosmetic) {
                    init_ = f.apply((Object)ability, stack, init_);
                }
            }
            return init_;
        });
    }

    public static <C> void iterateComponents(DataComponentType<C> type, LivingEntity entity, Visitor<C> visitor) {
        EquipmentHelper.reduceComponents(type, entity, Unit.INSTANCE, (unit, stack, component) -> {
            visitor.visit(stack, component);
            return Unit.INSTANCE;
        });
    }

    public static <C, ACC> ACC reduceComponents(DataComponentType<C> type, LivingEntity entity, ACC init, Accumulator<C, ACC> visitor) {
        return (ACC)EquipmentHelper.reduceEquipment(entity, init, (stack, acc) -> {
            Object component = stack.get(type);
            if (component != null) {
                acc = visitor.accumulate((Object)acc, (ItemStack)stack, (Object)component);
            }
            return acc;
        });
    }

    public static void iterateEquipment(LivingEntity entity, Consumer<ItemStack> consumer) {
        EquipmentHelper.reduceEquipment(entity, Unit.INSTANCE, (stack, unit) -> {
            consumer.accept((ItemStack)stack);
            return unit;
        });
    }

    public static <ACC> ACC reduceEquipment(LivingEntity entity, ACC init, BiFunction<ItemStack, ACC, ACC> f) {
        return EquipmentSlotManager.reduceEquipment(entity, init, f);
    }

    @FunctionalInterface
    public static interface Accumulator<E, ACC> {
        public ACC accumulate(ACC var1, ItemStack var2, E var3);
    }

    @FunctionalInterface
    public static interface Visitor<E> {
        public void visit(ItemStack var1, E var2);
    }
}

