/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.smarterfarmers;

import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class EatFoodGoal
extends Behavior<Villager> {
    private int eatingTime;
    private int cooldown = 0;
    private int buffer = 40;

    public EatFoodGoal(int minDur, int maxDur) {
        super(Map.of(MemoryModuleType.INTERACTION_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.HURT_BY_ENTITY, MemoryStatus.VALUE_ABSENT, MemoryModuleType.HURT_BY, MemoryStatus.VALUE_ABSENT, MemoryModuleType.NEAREST_HOSTILE, MemoryStatus.VALUE_ABSENT), minDur, maxDur);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (pOwner.isBaby()) {
            return false;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (pOwner.tickCount - pOwner.getLastHurtByMobTimestamp() < 400) {
            return false;
        }
        if (pOwner.getBrain().isActive(Activity.PANIC)) {
            return false;
        }
        if (pOwner.getHealth() < pOwner.getMaxHealth() && pOwner.getInventory().hasAnyOf(Villager.FOOD_POINTS.keySet())) {
            --this.buffer;
            return this.buffer <= 0;
        }
        return false;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.start(pLevel, (LivingEntity)pEntity, pGameTime);
        this.buffer = 40;
        pEntity.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        pEntity.getNavigation().stop();
        this.eatingTime = 80;
        SimpleContainer inventory = pEntity.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack itemstack = inventory.getItem(i);
            Integer food = (Integer)Villager.FOOD_POINTS.get(itemstack.getItem());
            if (food == null) continue;
            ItemStack s = itemstack.copy();
            s.setCount(1);
            if (itemstack.getCount() == 0) {
                inventory.setItem(i, ItemStack.EMPTY);
            }
            pEntity.setItemInHand(InteractionHand.MAIN_HAND, s);
        }
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        if (pEntity.getBrain().isActive(Activity.PANIC)) {
            return false;
        }
        if (pEntity.tickCount - pEntity.getLastHurtByMobTimestamp() < 200) {
            return false;
        }
        return this.eatingTime > 0 && Villager.FOOD_POINTS.get(pEntity.getMainHandItem().getItem()) != null;
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        if (this.eatingTime-- < 50) {
            ItemStack stack = pOwner.getMainHandItem();
            if (stack.isEmpty()) {
                return;
            }
            if (this.eatingTime % 2 == 0) {
                pLevel.broadcastEntityEvent((Entity)pOwner, (byte)45);
            }
            if (this.eatingTime % 5 == 0) {
                pOwner.playSound(pOwner.getEatingSound(stack), 0.3f + 0.4f * (float)pLevel.random.nextInt(2), (pLevel.random.nextFloat() - pLevel.random.nextFloat()) * 0.2f + 1.3f);
            }
        }
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        Integer food;
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
        ItemStack stack = pEntity.getMainHandItem();
        Item item = stack.getItem();
        pEntity.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        if (item != Items.AIR && this.eatingTime <= 0 && (food = (Integer)Villager.FOOD_POINTS.get(item)) != null) {
            for (int i = 0; i < pEntity.getInventory().getContainerSize(); ++i) {
                ItemStack s = pEntity.getInventory().getItem(i);
                if (s.getItem() != item) continue;
                s.split(1);
                pEntity.heal((float)Math.max(1, food));
                item.finishUsingItem(stack, (Level)pLevel, (LivingEntity)pEntity);
                this.cooldown = 20 * (4 + pLevel.random.nextInt(14)) + pLevel.random.nextInt(20);
                return;
            }
        }
    }
}

