/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.utils;

import java.util.ArrayList;
import java.util.List;

public class ReflectionUtils {
    public static boolean canCast(Class<?> obj, Class<?> caster) {
        if (obj.equals(caster)) {
            return true;
        }
        List<Class<?>> d1 = ReflectionUtils.getParent(obj, true);
        if (d1.contains(caster)) {
            return true;
        }
        d1 = ReflectionUtils.getParent(caster, true);
        return d1.contains(obj);
    }

    public static List<Class<?>> getParent(Class<?> obj, boolean useInterfaces) {
        ArrayList classes = new ArrayList();
        if (useInterfaces) {
            for (Class<?> anInterface : obj.getInterfaces()) {
                classes.add(anInterface);
                classes.addAll(ReflectionUtils.getParent(anInterface, true));
            }
        }
        if (obj.getSuperclass() != null) {
            classes.add(obj.getSuperclass());
            classes.addAll(ReflectionUtils.getParent(obj.getSuperclass(), useInterfaces));
        }
        return classes;
    }
}

