/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.widgets.text.printable;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.sixik.sdmuilibrary.client.utils.misc.RGB;
import net.sixik.sdmuilibrary.client.widgets.text.printable.PrintableBaseTextWidget;

public class PrintableMultiLineTextWidget
extends PrintableBaseTextWidget {
    public PrintableMultiLineTextWidget(Component text) {
        super(text);
    }

    public void calculate() {
        this.lines.clear();
        int currentLine = 0;
        for (String line : this.lT.split("\n")) {
            if (Minecraft.getInstance().font.width(line) > this.width) {
                String[] words = line.split(" ");
                StringBuilder currentWord = new StringBuilder();
                for (String word : words) {
                    if (Minecraft.getInstance().font.width(currentWord.toString() + " " + word) > this.width) {
                        this.lines.add(currentWord.toString());
                        currentWord.setLength(0);
                        ++currentLine;
                    }
                    currentWord.append(word).append(" ");
                }
                if (currentWord.isEmpty()) continue;
                this.lines.add(currentWord.toString());
                continue;
            }
            this.lines.add(line);
        }
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
        this.calculate();
        int posY = y;
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = (String)this.lines.get(i);
            graphics.drawString(Minecraft.getInstance().font, line, x, posY, RGB.create(255, 255, 255).toInt());
            Objects.requireNonNull(Minecraft.getInstance().font);
            posY += 9 * i + 2;
        }
        this.printTick();
    }
}

