/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.widgets.scroll;

import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.widgets.RenderWidget;
import net.sixik.sdmuilibrary.client.widgets.SDMWidget;

public class ScrollWidget
extends RenderWidget {
    private int maxScroll = 0;
    private int scroll;
    public boolean scrolling = false;

    public ScrollWidget(Vector2 position, Vector2 size) {
        super(position, size);
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
        if (this.visible) {
            int totalHeight = 0;
            int lastPosY = 0;
            for (SDMWidget widget : this.renderables) {
                if (lastPosY < widget.getY() || totalHeight == 0) {
                    totalHeight += widget.getHeight();
                    lastPosY = widget.getY();
                }
                this.renderWidget(widget, graphics, x, y - this.scroll, width, height, mouseX, mouseY, tick);
                widget.setPosition(widget.getX(), widget.getY() - this.scroll);
            }
            if (totalHeight > this.getHeight()) {
                this.maxScroll = totalHeight - this.getHeight();
            }
            if (this.maxScroll > 0) {
                this.drawScrollBar(graphics, x + this.getWidth() - 5, y, height, totalHeight);
            }
        }
    }

    private void drawScrollBar(GuiGraphics graphics, int x, int y, int height, int contentHeight) {
        int scrollbarHeight = Math.max(20, (int)((float)this.getHeight() / (float)contentHeight * (float)this.getHeight()));
        int scrollbarY = y + (int)((float)this.scroll / (float)this.maxScroll * (float)(this.getHeight() - scrollbarHeight));
        graphics.fill(x, y, x + 5, y + this.getHeight(), -5592406);
        graphics.fill(x, scrollbarY, x + 5, scrollbarY + scrollbarHeight, -16777216);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta, double d1) {
        this.scrolling = true;
        if (this.scrolling) {
            this.scroll = (int)((double)this.scroll - d1);
        }
        System.out.println(this.scroll);
        return super.mouseScrolled(mouseX, mouseY, scrollDelta, d1);
    }

    @Override
    public boolean mouseReleased(double p_93684_, double p_93685_, int p_93686_) {
        this.scrolling = false;
        return super.mouseReleased(p_93684_, p_93685_, p_93686_);
    }

    private void setScroll(int scroll) {
        this.scroll = Math.min(this.maxScroll, Math.max(0, scroll));
        System.out.println(scroll);
    }
}

