/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.widgets.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.sixik.sdmuilibrary.client.utils.RenderHelper;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.math.Vector2d;
import net.sixik.sdmuilibrary.client.utils.misc.Colors;
import net.sixik.sdmuilibrary.client.utils.misc.CursorType;
import net.sixik.sdmuilibrary.client.utils.renders.GLRenderHelper;
import net.sixik.sdmuilibrary.client.utils.renders.TextRenderHelper;
import net.sixik.sdmuilibrary.client.widgets.buttons.BasicButtonWidget;

public class BaseDropDownListWidget<T>
extends BasicButtonWidget {
    private Function<T, Component> toNameFunc = t -> Component.literal((String)t.toString());
    private Consumer<T> responder = t -> {};
    private final List<T> possibleValues;
    private T value;
    private final int maxDisplayed;
    private final int maxScroll;
    private int scroll;
    private boolean opened;
    public Vector2 size;
    private int sizeOfTextField = RenderHelper.getTextHeight() + 1;

    public BaseDropDownListWidget(Vector2 pos, int weight, int maxDisplayed, Collection<T> possibleValues, T value) {
        super(pos, new Vector2(weight, RenderHelper.getTextHeight() + 1));
        this.size = new Vector2(weight, this.sizeOfTextField);
        this.possibleValues = new ArrayList<T>(possibleValues);
        this.value = value;
        this.maxDisplayed = maxDisplayed = Math.min(maxDisplayed, possibleValues.size());
        this.maxScroll = possibleValues.size() - maxDisplayed;
        this.opened = false;
    }

    public BaseDropDownListWidget<T> setSizeOfTextField(int sizeOfTextField) {
        this.sizeOfTextField = sizeOfTextField;
        return this;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.opened) {
            return false;
        }
        this.setScroll(this.scroll - Mth.sign((double)scrollY));
        return false;
    }

    @Override
    public void drawMouseOver(GuiGraphics graphics, int x, int y, int width, int height, float tick) {
        if (this.isMouseOver((double)x, (double)y)) {
            CursorType.set(this.getCursor());
        } else {
            CursorType.set(null);
        }
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
        Colors.POLAR_NIGHT_0.draw(graphics, x, y, this.size.x, this.sizeOfTextField);
        String line = this.toNameFunc.apply(this.value).getString();
        TextRenderHelper.drawTextOverWight(graphics, line, new Vector2(x + 1, y + 1), width - 1);
        this.drawList(graphics, x, y + this.sizeOfTextField, this.size.x, this.size.y, mouseX, mouseY);
    }

    public void drawList(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY) {
        if (this.opened) {
            GLRenderHelper.enableScissor(graphics, new Vector2(x, y), new Vector2(width, this.sizeOfTextField * this.maxDisplayed));
            for (int i = 0; i < this.maxDisplayed; ++i) {
                this.drawContent(graphics, x, y, width, this.sizeOfTextField, mouseX, mouseY, i);
                y += this.sizeOfTextField;
            }
            GLRenderHelper.disableScissor(graphics);
        }
    }

    public void drawContent(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, int num) {
        Colors.POLAR_NIGHT_1.draw(graphics, x, y, width, height);
        if (RenderHelper.isMouseOver(Vector2d.create(mouseX, mouseY), Vector2.of(x, y), Vector2.of(width, height))) {
            Colors.POLAR_NIGHT_2.draw(graphics, x, y, width, height);
        }
        String line = this.toNameFunc.apply(this.possibleValues.get(num + this.scroll)).getString();
        TextRenderHelper.drawTextOverWight(graphics, line, new Vector2(++x, ++y), width - 1);
    }

    public BaseDropDownListWidget<T> setToNameFunc(Function<T, Component> function) {
        this.toNameFunc = function;
        this.possibleValues.sort((v1, v2) -> {
            String name1 = ((Component)function.apply(v1)).getString();
            String name2 = ((Component)function.apply(v2)).getString();
            return name1.compareTo(name2);
        });
        return this;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        boolean clicked = super.clicked(mouseX, mouseY);
        if (!clicked) {
            this.opened = false;
            this.setSize();
        }
        return clicked;
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
        boolean bl = this.opened = !this.opened;
        if (RenderHelper.isMouseOver(Vector2d.create(mouseX, mouseY), Vector2.of(this.getX(), this.getY() + this.sizeOfTextField), Vector2.of(this.width, this.height))) {
            int clickedLine = ((int)mouseY - this.getY() - this.sizeOfTextField - 1) / this.sizeOfTextField + this.scroll;
            this.value = this.possibleValues.get(clickedLine);
            this.responder.accept(this.value);
        }
        this.setSize();
    }

    public void setSize() {
        if (this.opened) {
            this.width = this.size.x;
            this.height = this.size.y + this.maxDisplayed * this.sizeOfTextField;
        } else {
            this.width = this.size.x;
            this.height = this.size.y;
        }
    }

    public BaseDropDownListWidget<T> setResponder(Consumer<T> responder) {
        this.responder = responder;
        return this;
    }

    private void setScroll(int scroll) {
        this.scroll = Math.min(this.maxScroll, Math.max(0, scroll));
    }
}

