/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.widgets.buttons;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.misc.CenterOperators;
import net.sixik.sdmuilibrary.client.utils.misc.RGB;
import net.sixik.sdmuilibrary.client.widgets.buttons.BasicButtonWidget;

public class SimpleButtonWidget
extends BasicButtonWidget {
    public RGB color = RGB.create(255, 255, 255);
    public List<String> lines = new ArrayList<String>();
    public int maxWidth = 0;

    public SimpleButtonWidget(Component title) {
        this(title, null, null);
    }

    public SimpleButtonWidget(Component title, Vector2 size) {
        this(title, null, size);
    }

    public SimpleButtonWidget(Component title, Vector2 position, Vector2 size) {
        super(position, size);
        this.setTitle(title);
    }

    @Override
    public void setTitle(Component title) {
        super.setTitle(title);
        this.calculate();
    }

    public void setColor(RGB color) {
        this.color = color;
    }

    @Override
    public void onClick(double mouseX, double mouseY) {
    }

    public CenterOperators.Type getCenteredType() {
        return CenterOperators.Type.NONE;
    }

    public void calculate() {
        this.lines.clear();
        int currentLine = 0;
        for (String line : this.title.getString().split("\n")) {
            if (Minecraft.getInstance().font.width(line) > this.width) {
                String[] words = line.split(" ");
                StringBuilder currentWord = new StringBuilder();
                for (String word : words) {
                    int d1 = Minecraft.getInstance().font.width(currentWord.toString() + " " + word);
                    if (d1 > this.width) {
                        if (d1 > this.maxWidth) {
                            this.maxWidth = d1;
                        }
                        this.lines.add(currentWord.toString());
                        currentWord.setLength(0);
                        ++currentLine;
                    }
                    currentWord.append(word).append(" ");
                }
                if (currentWord.isEmpty()) continue;
                this.lines.add(currentWord.toString());
                continue;
            }
            this.lines.add(line);
        }
    }

    @Override
    public void drawTitle(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
        int posY = y;
        int posX = x;
        if (Objects.requireNonNull(this.getCenteredType()) == CenterOperators.Type.CENTER_Y || Objects.requireNonNull(this.getCenteredType()) == CenterOperators.Type.CENTER_XY) {
            posY = y + height / 3;
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            String line = this.lines.get(i);
            if (this.getCenteredType() == CenterOperators.Type.CENTER_X || this.getCenteredType() == CenterOperators.Type.CENTER_XY) {
                posX += (width - Minecraft.getInstance().font.width(line)) / 3;
            }
            graphics.drawString(Minecraft.getInstance().font, line, posX, posY, this.color.toInt());
            Objects.requireNonNull(Minecraft.getInstance().font);
            posY -= 9 / 2;
            Objects.requireNonNull(Minecraft.getInstance().font);
            posY += 9 * i + 2;
        }
    }
}

