/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.widgets.buttons;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.misc.CursorType;
import net.sixik.sdmuilibrary.client.utils.misc.RGBA;
import net.sixik.sdmuilibrary.client.widgets.SDMWidget;
import org.jetbrains.annotations.Nullable;

public class ColorButtonWidget
extends SDMWidget {
    public Consumer<RGBA> responder = s -> {};
    @Nullable
    public RGBA selectedColor;
    public int currentColorId = 0;
    public List<RGBA> colors;

    public ColorButtonWidget(List<RGBA> colors, Vector2 position, Vector2 size) {
        this(colors.isEmpty() ? null : colors.get(0), colors, position, size);
    }

    public ColorButtonWidget(@Nullable RGBA selectedColor, List<RGBA> colors, Vector2 position, Vector2 size) {
        super(position, size);
        this.selectedColor = selectedColor;
        this.colors = colors;
        this.drawMouseOver = true;
    }

    public ColorButtonWidget setResponder(Consumer<RGBA> responder) {
        this.responder = responder;
        return this;
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int width, int height, int mouseX, int mouseY, float tick) {
        if (this.selectedColor == null) {
            return;
        }
        this.selectedColor.draw(graphics, x, y, width, height);
    }

    @Override
    @Nullable
    public CursorType getCursor() {
        return CursorType.HAND;
    }

    public void onClick(double p_93634_, double p_93635_) {
        if (this.colors.isEmpty()) {
            return;
        }
        this.selectedColor = this.colors.get(this.currentColorId);
        this.responder.accept(this.selectedColor);
        ++this.currentColorId;
        if (this.currentColorId >= this.colors.size()) {
            this.currentColorId = 0;
        }
    }
}

