/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.utils.renders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.math.Vector2f;
import net.sixik.sdmuilibrary.client.utils.misc.RGB;
import net.sixik.sdmuilibrary.client.utils.renders.GLRenderHelper;

public class TextRenderHelper {
    public static void drawText(GuiGraphics poseStack, int x, int y, float size, Component text, int textColor) {
        TextRenderHelper.drawText(poseStack, Minecraft.getInstance().font, x, y, size, text, textColor);
    }

    public static void drawText(GuiGraphics poseStack, Font font, int x, int y, float size, Component text, int textColor) {
        poseStack.pose().pushPose();
        GLRenderHelper.setScale(poseStack, size, x, y);
        poseStack.drawString(font, text, x, y, textColor);
        poseStack.pose().popPose();
    }

    public static void drawText(GuiGraphics graphics, Component text, int x, int y) {
        graphics.drawString(Minecraft.getInstance().font, text.toString(), x, y, RGB.create(255, 255, 255).toInt());
    }

    public static void drawText(GuiGraphics graphics, String text, int x, int y) {
        graphics.drawString(Minecraft.getInstance().font, text, x, y, RGB.create(255, 255, 255).toInt());
    }

    public static void drawText(GuiGraphics graphics, Component text, int x, int y, RGB rgb) {
        graphics.drawString(Minecraft.getInstance().font, text.toString(), x, y, rgb.toInt());
    }

    public static void drawText(GuiGraphics graphics, String text, int x, int y, RGB rgb) {
        graphics.drawString(Minecraft.getInstance().font, text, x, y, rgb.toInt());
    }

    public static void drawTextOverWight(GuiGraphics graphics, String text, Vector2 pos, int wight) {
        TextRenderHelper.drawTextOverWight(graphics, Minecraft.getInstance().font, text, pos, wight, RGB.create(255, 255, 255));
    }

    public static void drawTextOverWight(GuiGraphics graphics, String text, Vector2 pos, int wight, RGB rgb) {
        TextRenderHelper.drawTextOverWight(graphics, Minecraft.getInstance().font, text, pos, wight, rgb);
    }

    public static void drawTextOverWight(GuiGraphics graphics, Font font, String text, Vector2 pos, int wight, RGB rgb) {
        if (font.width((String)text) > wight - 10) {
            while (font.width((String)text + "...") > wight - 10) {
                text = ((String)text).substring(0, ((String)text).length() - 1);
            }
            text = (String)text + "...";
        }
        graphics.drawString(Minecraft.getInstance().font, (String)text, pos.x, pos.y, rgb.toInt());
    }

    public static void drawTextInCenter(GuiGraphics graphics, Object text, Vector2 pos, Vector2 size, float scale, RGB color) {
        int w = size.x;
        int h = size.y;
        Objects.requireNonNull(Minecraft.getInstance().font);
        int fontSize = 9;
        int textWidth = TextRenderHelper.getTextWight(text, scale);
        float scaledFontHeight = (float)fontSize * scale;
        float textX = (float)pos.x + (float)(w - textWidth) / 2.0f;
        float textY = (float)pos.y + ((float)h - scaledFontHeight) / 2.0f;
        graphics.pose().pushPose();
        graphics.pose().scale(scale, scale, scale);
        int colorInt = color.toInt();
        if (text instanceof FormattedCharSequence) {
            graphics.drawString(Minecraft.getInstance().font, (FormattedCharSequence)text, (int)(textX / scale), (int)(textY / scale), colorInt);
        } else if (text instanceof String) {
            graphics.drawString(Minecraft.getInstance().font, (Component)Component.literal((String)((String)text)), (int)(textX / scale), (int)(textY / scale), colorInt);
        }
        graphics.pose().popPose();
    }

    public static Vector2f getTextRenderSize(Object text, int wight, float scale, int steps) {
        float s = scale;
        float w = 0.0f;
        String t = TextRenderHelper.getText(text);
        for (int i = 0; i < steps; ++i) {
            w = TextRenderHelper.getTextWidth(t, s);
            s -= 0.01f;
            if (!(w <= (float)wight)) continue;
            return new Vector2f(w, s);
        }
        return new Vector2f(s, w);
    }

    public static int getTextHeight() {
        Objects.requireNonNull(Minecraft.getInstance().font);
        return 9;
    }

    public static float getTextHeight(float scale) {
        int d1 = TextRenderHelper.getTextHeight();
        int d2 = (int)((float)d1 * scale);
        return d1 + (d1 - d2);
    }

    public static int getTextWidth(Object text) {
        return Minecraft.getInstance().font.width(TextRenderHelper.getText(text));
    }

    public static float getTextWidth(Object text, float scale) {
        int baseWidth = Minecraft.getInstance().font.width(TextRenderHelper.getText(text));
        return (float)baseWidth * scale;
    }

    public static int getTextWight(Object text, float size) {
        return (int)TextRenderHelper.getTextWidth(TextRenderHelper.getText(text), size);
    }

    public static float getAdjustedTextWidth(Object text, float scale) {
        int d2;
        int d1 = Minecraft.getInstance().font.width(TextRenderHelper.getText(text));
        int result = d1 + (d1 - (d2 = (int)((float)d1 * scale)));
        return result == d1 ? 0.0f : (float)result;
    }

    public static float getAdjustedTextHeight(float scale) {
        int d2;
        int d1 = TextRenderHelper.getTextHeight();
        int result = d1 + (d1 - (d2 = (int)((float)d1 * scale)));
        return result == d1 ? 0.0f : (float)result;
    }

    public static List<String> splitTextToLines(String text, float textScale, int maxWidth) {
        if (text.isEmpty()) {
            return Collections.emptyList();
        }
        if (!text.contains(" ") && !text.contains("\n")) {
            return Collections.singletonList(text);
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int wordStartIndex = 0;
        boolean wordProcessing = false;
        char prevSymbol = '0';
        for (char symbol : text.toCharArray()) {
            if (symbol != ' ') {
                wordProcessing = true;
                if (prevSymbol == ' ') {
                    wordStartIndex = index;
                }
            }
            if (symbol == '\n') {
                lines.add(builder.toString());
                builder.delete(0, builder.length());
                index = 0;
                continue;
            }
            if (TextRenderHelper.getTextWidth(builder.toString() + symbol, textScale) <= (float)maxWidth) {
                builder.append(symbol);
            } else {
                if (symbol == '.' || symbol == ',' || symbol == '!' || symbol == '?') {
                    builder.append(symbol);
                }
                if (wordProcessing) {
                    lines.add(builder.toString().substring(0, wordStartIndex));
                    builder.delete(0, wordStartIndex);
                } else {
                    lines.add(builder.toString());
                    builder.delete(0, builder.length());
                }
                if (symbol != ' ') {
                    builder.append(symbol);
                }
                index = builder.length() - 1;
            }
            wordProcessing = false;
            prevSymbol = symbol;
            ++index;
        }
        if (builder.length() != 0) {
            lines.add(builder.toString());
        }
        return lines;
    }

    public static String getText(Object object) {
        if (object instanceof String) {
            String str = (String)object;
            return str;
        }
        if (object instanceof Component) {
            Component component = (Component)object;
            return component.toString();
        }
        if (object instanceof FormattedText) {
            FormattedText formattedText = (FormattedText)object;
            return formattedText.getString();
        }
        return object.toString();
    }
}

