/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.utils.renders;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.sixik.sdmuilibrary.client.utils.DrawDirection;
import net.sixik.sdmuilibrary.client.utils.buffers.RenderBuffer2D;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.math.Vector2f;
import net.sixik.sdmuilibrary.client.utils.misc.LineVectors;
import net.sixik.sdmuilibrary.client.utils.misc.RGB;
import net.sixik.sdmuilibrary.client.utils.misc.RGBA;
import org.joml.Matrix4f;

public class ShapesRenderHelper {
    public static void drawQuad(Matrix4f m, Vector2 pos, Vector2 size, RGB rgb) {
        ShapesRenderHelper.drawQuad(m, pos.toVector2f(), size.toVector2f(), rgb);
    }

    public static void drawQuad(Matrix4f m, Vector2f pos, Vector2f size, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        ShapesRenderHelper.drawQuad(m, pos, size, r, g, b, a);
    }

    public static void drawQuad(Matrix4f m, Vector2f pos, Vector2f size, int r, int g, int b, int a) {
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderBuffer2D.addQuadToBuffer(m, (VertexConsumer)buffer, pos, size, r, g, b, a);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void drawStraight(Matrix4f m, Vector2 pos, LineVectors vectors, float _long, float size, RGB rgb) {
        ShapesRenderHelper.drawStraight(m, pos.toVector2f(), vectors, _long, size, rgb);
    }

    public static void drawStraight(Matrix4f m, Vector2f pos, LineVectors vectors, float _long, float size, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        ShapesRenderHelper.drawStraight(m, pos, vectors, _long, size, r, g, b, a);
    }

    public static void drawStraight(Matrix4f m, Vector2f pos, LineVectors vectors, float _long, float size, int r, int g, int b, int a) {
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderBuffer2D.addStraightToBuffer(m, (VertexConsumer)buffer, pos, vectors, _long, size, r, g, b, a);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static void drawMagneticLine(Matrix4f m, Vector2 pos1, LineVectors magnet1, Vector2 pos2, LineVectors magnet2, float size, RGB rgb) {
        ShapesRenderHelper.drawMagneticLine(m, pos1.toVector2f(), magnet1, pos2.toVector2f(), magnet2, size, rgb);
    }

    public static void drawMagneticLine(Matrix4f m, Vector2f pos1, LineVectors magnet1, Vector2f pos2, LineVectors magnet2, float size, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        ShapesRenderHelper.drawMagneticLine(m, pos1, magnet1, pos2, magnet2, size, r, g, b, a);
    }

    public static void drawMagneticLine(Matrix4f m, Vector2f pos1, LineVectors magnet1, Vector2f pos2, LineVectors magnet2, float size, int r, int g, int b, int a) {
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderBuffer2D.addLineMagnetToBuffer(m, (VertexConsumer)buffer, pos1, magnet1, pos2, magnet2, size, r, g, b, a);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    private static void drawFillRect(GuiGraphics guiGraphics, int x, int y, int width, int height, RGB rgb) {
        guiGraphics.fill(x, y, x + width, y + height, ShapesRenderHelper.rgbaToInt(rgb.r, rgb.g, rgb.b, rgb instanceof RGBA ? ((RGBA)rgb).a : 255));
    }

    public static void drawTriangle(Matrix4f m, Vector2 pos, Vector2 size, DrawDirection direction, RGB rgb) {
        ShapesRenderHelper.drawTriangle(m, pos.toVector2f(), size.toVector2f(), direction, rgb);
    }

    public static void drawTriangle(Matrix4f m, Vector2f pos, Vector2f size, DrawDirection direction, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        ShapesRenderHelper.drawTriangle(m, pos, size, direction, r, g, b, a);
    }

    public static void drawTriangle(Matrix4f m, Vector2 pos, Vector2 size, DrawDirection direction, int r, int g, int b, int a) {
        ShapesRenderHelper.drawTriangle(m, pos.toVector2f(), size.toVector2f(), direction, r, g, b, a);
    }

    public static void drawTriangle(Matrix4f m, Vector2f pos, Vector2f size, DrawDirection direction, int r, int g, int b, int a) {
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderBuffer2D.addTriangleToBuffer(m, (VertexConsumer)buffer, pos, size, direction, r, g, b, a);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawCircle(Matrix4f m, Vector2 pos, float size, int segments, RGB rgb) {
        ShapesRenderHelper.drawCircle(m, pos.toVector2f(), size, segments, rgb);
    }

    public static void drawCircle(Matrix4f m, Vector2f pos, float size, int segments, RGB rgb) {
        int r = rgb.r;
        int g = rgb.g;
        int b = rgb.b;
        int a = 255;
        if (rgb instanceof RGBA) {
            RGBA rgba = (RGBA)rgb;
            a = rgba.a;
        }
        ShapesRenderHelper.drawCircle(m, pos, size, segments, r, g, b, a);
    }

    public static void drawCircle(Matrix4f m, Vector2f pos, float size, int segments, int r, int g, int b, int a) {
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderBuffer2D.addCircleToBuffer(m, (VertexConsumer)buffer, pos, size, segments, r, g, b, a);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawArc(GuiGraphics guiGraphics, Vector2 pos, int radius, int startAngle, int endAngle, RGB rgb) {
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tesselator.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderBuffer2D.addArcToBuffer(guiGraphics.pose().last().pose(), (VertexConsumer)bufferBuilder, pos.x, pos.y, radius, startAngle, endAngle, rgb);
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.disableBlend();
    }

    public static void drawRoundedRect(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, RGB rgb) {
        Matrix4f m = guiGraphics.pose().last().pose();
        ShapesRenderHelper.drawFillRect(guiGraphics, x, y + radius, width, height - radius * 2, rgb);
        ShapesRenderHelper.drawFillRect(guiGraphics, x + radius, y, width - radius * 2, radius, rgb);
        ShapesRenderHelper.drawFillRect(guiGraphics, x + radius, y + height - radius, width - radius * 2, radius, rgb);
        ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + radius, y + radius), radius, 270, 180, rgb);
        ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + width - radius, y + radius), radius, 0, -90, rgb);
        ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + radius, y + height - radius), radius, -180, -270, rgb);
        ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + width - radius, y + height - radius), radius, 90, 0, rgb);
    }

    public static void drawRoundedRect(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, RGB rgb, DrawDirection direction) {
        Matrix4f m = guiGraphics.pose().last().pose();
        switch (direction) {
            case UP: {
                ShapesRenderHelper.drawFillRect(guiGraphics, x, y + radius, width, height - radius, rgb);
                ShapesRenderHelper.drawFillRect(guiGraphics, x + radius, y, width - radius * 2, radius, rgb);
                ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + radius, y + radius), radius, 270, 180, rgb);
                ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + width - radius, y + radius), radius, 0, -90, rgb);
                return;
            }
            case DOWN: {
                ShapesRenderHelper.drawFillRect(guiGraphics, x, y, width, height - radius, rgb);
                ShapesRenderHelper.drawFillRect(guiGraphics, x + radius, y + height - radius, width - radius * 2, radius, rgb);
                ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + radius, y + height - radius), radius, -180, -270, rgb);
                ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + width - radius, y + height - radius), radius, 90, 0, rgb);
                return;
            }
            case LEFT: {
                ShapesRenderHelper.drawFillRect(guiGraphics, x + radius, y, width - radius, height, rgb);
                ShapesRenderHelper.drawFillRect(guiGraphics, x, y + radius, radius, height - radius * 2, rgb);
                ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + radius, y + radius), radius, 270, 180, rgb);
                ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + radius, y + height - radius), radius, -180, -270, rgb);
                return;
            }
            case RIGHT: {
                ShapesRenderHelper.drawFillRect(guiGraphics, x, y, width - radius, height, rgb);
                ShapesRenderHelper.drawFillRect(guiGraphics, x + width - radius, y + radius, radius, height - radius * 2, rgb);
                ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + width - radius, y + radius), radius, 0, -90, rgb);
                ShapesRenderHelper.drawArc(guiGraphics, new Vector2(x + width - radius, y + height - radius), radius, 90, 0, rgb);
                return;
            }
        }
        throw new UnsupportedOperationException("Not implemented yet for this operation '" + direction.name() + "'");
    }

    public static void drawLineTC(GuiGraphics poseStack, int x, int y, int x2, int y2, float instability, float op) {
        if (instability > 0.01f) {
            int a;
            double dist = Mth.sqrt((float)((x - x2) * (x - x2) + (y - y2) * (y - y2))) * instability;
            double xd = (double)(x2 - x) / dist;
            double yd = (double)(y2 - y) / dist;
            Random rand = new Random();
            int xr = 0;
            int yr = 0;
            int inc = (int)Math.floor(dist - 1.0);
            for (a = 0; a < inc; ++a) {
                int xrn = rand.nextInt(2) - rand.nextInt(2);
                int yrn = rand.nextInt(2) - rand.nextInt(2);
                ShapesRenderHelper.drawLineTC(poseStack, (int)((double)x + xd * (double)a) + xr, (int)((double)y + yd * (double)a) + yr, (int)((double)x + xd * (double)(a + 1)) + xrn, (int)((double)y + yd * (double)(a + 1)) + yrn, op);
                xr = xrn;
                yr = yrn;
            }
            ShapesRenderHelper.drawLineTC(poseStack, (int)((double)x + xd * (double)a) + xr, (int)((double)y + yd * (double)a) + yr, x2, y2, op);
        } else {
            ShapesRenderHelper.drawLineTC(poseStack, x, y, x2, y2, op);
        }
    }

    public static void drawLineTC(GuiGraphics poseStack, int x, int y, int x2, int y2, float op) {
        Minecraft mc = Minecraft.getInstance();
        long count = mc.level.getGameTime();
        float bob = Mth.sin((float)(((float)count + (float)x2) / 10.0f)) * 0.15f + 0.15f;
        float bob2 = Mth.sin((float)(((float)count + (float)x + (float)y2) / 11.0f)) * 0.15f + 0.15f;
        float bob3 = Mth.sin((float)(((float)count + (float)y) / 12.0f)) * 0.15f + 0.15f;
        GlStateManager._depthMask((boolean)false);
        GlStateManager._disableCull();
        RenderSystem.setShader(GameRenderer::getRendertypeLinesShader);
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder buffer = tesselator.begin(VertexFormat.Mode.LINES, DefaultVertexFormat.POSITION_COLOR_NORMAL);
        RenderSystem.lineWidth((float)2.0f);
        buffer.addVertex((float)x, (float)y, 0.0f).setColor(bob, bob2, bob3, op).setNormal(1.0f, 1.0f, 1.0f);
        buffer.addVertex((float)x2, (float)y2, 0.0f).setColor(bob, bob2, bob3, op).setNormal(1.0f, 1.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.lineWidth((float)1.0f);
        GlStateManager._enableCull();
        GlStateManager._depthMask((boolean)true);
    }

    private static int rgbaToInt(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }
}

