/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.utils.renders;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.math.Vector2f;

public class GLRenderHelper {
    public static void enableScissor(GuiGraphics guiGraphics, Vector2 pos, Vector2 size) {
        guiGraphics.enableScissor(pos.x, pos.y, pos.x + size.x, pos.y + size.y);
    }

    public static void enableScissorFor(GuiGraphics guiGraphics, Vector2 pos, Vector2 size, Runnable runnable) {
        GLRenderHelper.enableScissor(guiGraphics, pos, size);
        runnable.run();
        GLRenderHelper.disableScissor(guiGraphics);
    }

    public static void enableScissor(GuiGraphics guiGraphics, int posX, int posY, int weight, int height) {
        guiGraphics.enableScissor(posX, posY, posX + weight, posY + height);
    }

    public static void enableScissorFor(GuiGraphics guiGraphics, int posX, int posY, int weight, int height, Runnable runnable) {
        GLRenderHelper.enableScissor(guiGraphics, posX, posY, weight, height);
        runnable.run();
        GLRenderHelper.disableScissor(guiGraphics);
    }

    public static void disableScissor(GuiGraphics guiGraphics) {
        guiGraphics.disableScissor();
    }

    public static void setScale(GuiGraphics guiGraphics, float scale, Vector2f pos) {
        GLRenderHelper.setScale(guiGraphics, scale, pos.x, pos.y);
    }

    public static void setScale(GuiGraphics guiGraphics, float scale, Vector2f pos, Runnable runnable) {
        GLRenderHelper.setScale(guiGraphics, scale, pos.x, pos.y, runnable);
    }

    public static void setScale(GuiGraphics guiGraphics, float scale, float centerX, float centerY) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        poseStack.translate(-centerX, -centerY, 0.0f);
    }

    public static void setScale(GuiGraphics guiGraphics, float scale, float centerX, float centerY, Runnable runnable) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        poseStack.translate(-centerX, -centerY, 0.0f);
        runnable.run();
        poseStack.popPose();
    }

    public static void setScaleByScreen(GuiGraphics guiGraphics, float scale, Runnable runnable) {
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        PoseStack poseStack = guiGraphics.pose();
        int w = window.getGuiScaledWidth();
        int h = window.getGuiScaledHeight();
        poseStack.translate((float)w / 2.0f, (float)h / 2.0f, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        poseStack.translate(-((float)w) / 2.0f, -((float)h) / 2.0f, 0.0f);
        runnable.run();
    }

    public static void setRotation(GuiGraphics guiGraphics, float rotation, Vector2f pos) {
        GLRenderHelper.setRotation(guiGraphics, rotation, pos.x, pos.y);
    }

    public static void setRotation(GuiGraphics guiGraphics, float rotation, Vector2f pos, Runnable runnable) {
        GLRenderHelper.setRotation(guiGraphics, rotation, pos.x, pos.y, runnable);
    }

    public static void setRotation(GuiGraphics guiGraphics, float rotation, float centerX, float centerY) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
        poseStack.translate(-centerX, -centerY, 0.0f);
    }

    public static void setRotation(GuiGraphics guiGraphics, float rotation, float centerX, float centerY, Runnable runnable) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
        poseStack.translate(-centerX, -centerY, 0.0f);
        runnable.run();
        poseStack.popPose();
    }

    public static void setTransform(GuiGraphics guiGraphics, Vector2 pos, float rotation, float scale) {
        GLRenderHelper.setTransform(guiGraphics, pos.x, (float)pos.y, rotation, scale);
    }

    public static void setTransform(GuiGraphics guiGraphics, Vector2 pos, float rotation, float scale, Runnable runnable) {
        GLRenderHelper.setTransform(guiGraphics, pos.x, pos.y, rotation, scale, runnable);
    }

    public static void setTransform(GuiGraphics guiGraphics, float centerX, float centerY, float rotation, float scale) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
        poseStack.translate(-centerX, -centerY, 0.0f);
    }

    public static void setTransform(GuiGraphics guiGraphics, float centerX, float centerY, float rotation, float scale, Runnable runnable) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(centerX, centerY, 0.0f);
        poseStack.scale(scale, scale, 1.0f);
        poseStack.mulPose(Axis.ZP.rotationDegrees(rotation));
        poseStack.translate(-centerX, -centerY, 0.0f);
        runnable.run();
        poseStack.popPose();
    }

    public static void setDepth(GuiGraphics guiGraphics, int depth) {
        guiGraphics.pose().translate(0.0f, 0.0f, (float)depth);
    }

    public static void setDepth(GuiGraphics guiGraphics, int depth, Runnable runnable) {
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, (float)depth);
        runnable.run();
        guiGraphics.pose().popPose();
    }
}

