/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.utils.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.sixik.sdmuilibrary.client.utils.misc.RGBA;
import net.sixik.sdmuilibrary.client.utils.misc.Texture;
import org.joml.Matrix4f;

public class AtlasTextureColor
extends Texture {
    protected AtlasTextureColor(ResourceLocation textureID) {
        super(textureID);
    }

    public static AtlasTextureColor create(ResourceLocation textureID) {
        return new AtlasTextureColor(textureID);
    }

    @Override
    public AtlasTextureColor copy() {
        return (AtlasTextureColor)new AtlasTextureColor(this.textureID).withColor(RGBA.create(this.r, this.g, this.b, this.a)).withUV(this.minU, this.minV, this.maxU, this.maxV);
    }

    @Override
    public void draw(GuiGraphics graphics, int x, int y, int w, int h) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getModelManager().getAtlas(InventoryMenu.BLOCK_ATLAS).getSprite(this.textureID);
        if (sprite != null) {
            Matrix4f m = graphics.pose().last().pose();
            int r = this.r;
            int g = this.g;
            int b = this.b;
            int a = this.a;
            float minU = sprite.getU0();
            float minV = sprite.getV0();
            float maxU = sprite.getU1();
            float maxV = sprite.getV1();
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            buffer.addVertex(m, (float)x, (float)y, 0.0f).setColor(r, g, b, a).setUv(minU, minV);
            buffer.addVertex(m, (float)x, (float)(y + h), 0.0f).setColor(r, g, b, a).setUv(minU, maxV);
            buffer.addVertex(m, (float)(x + w), (float)(y + h), 0.0f).setColor(r, g, b, a).setUv(maxU, maxV);
            buffer.addVertex(m, (float)(x + w), (float)y, 0.0f).setColor(r, g, b, a).setUv(maxU, minV);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            RenderSystem.disableBlend();
        }
    }
}

