/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmuilibrary.client.utils.math;

import net.sixik.sdmuilibrary.client.utils.math.Vector2;
import net.sixik.sdmuilibrary.client.utils.math.Vector2d;

public class Vector2f {
    public float x;
    public float y;

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f add(Vector2f other) {
        return new Vector2f(this.x + other.x, this.y + other.y);
    }

    public static Vector2f of(float x, float y) {
        return new Vector2f(x, y);
    }

    public Vector2f subtract(Vector2f other) {
        return new Vector2f(this.x - other.x, this.y - other.y);
    }

    public Vector2f multiply(float scalar) {
        return new Vector2f(this.x * scalar, this.y * scalar);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public Vector2f normalize() {
        float length = this.length();
        if (length == 0.0f) {
            return new Vector2f(0.0f, 0.0f);
        }
        return this.multiply(1.0f / length);
    }

    public float dot(Vector2f other) {
        return this.x * other.x + this.y * other.y;
    }

    public Vector2f cross(Vector2f other) {
        return new Vector2f(this.y * other.x - this.x * other.y, this.x * other.y - this.y * other.x);
    }

    public static Vector2f zero() {
        return new Vector2f(0.0f, 0.0f);
    }

    public static Vector2f one() {
        return new Vector2f(1.0f, 1.0f);
    }

    public static Vector2f up() {
        return new Vector2f(0.0f, 1.0f);
    }

    public static Vector2f down() {
        return new Vector2f(0.0f, -1.0f);
    }

    public static Vector2f left() {
        return new Vector2f(-1.0f, 0.0f);
    }

    public static Vector2f right() {
        return new Vector2f(1.0f, 0.0f);
    }

    public static float distance(Vector2f a, Vector2f b) {
        return a.subtract(b).length();
    }

    public static float distanceSquared(Vector2f a, Vector2f b) {
        return a.subtract(b).lengthSquared();
    }

    public static Vector2f lerp(Vector2f a, Vector2f b, float t) {
        return a.add(b.subtract(a).multiply(t));
    }

    public static Vector2f project(Vector2f a, Vector2f b) {
        float dotProduct = a.dot(b);
        float lengthSquared = b.lengthSquared();
        return b.multiply(dotProduct / lengthSquared);
    }

    public float toRadius() {
        return (float)Math.toRadians(this.toDegrees());
    }

    public float toDegrees() {
        return (float)Math.toDegrees(Math.atan2(this.y, this.x));
    }

    public static Vector2f reject(Vector2f a, Vector2f b) {
        return a.subtract(Vector2f.project(a, b));
    }

    public static Vector2f reflect(Vector2f incident, Vector2f normal) {
        return incident.subtract(normal.multiply(2.0f * incident.dot(normal)));
    }

    public static boolean equals(Vector2f a, Vector2f b) {
        return a.x == b.x && a.y == b.y;
    }

    public Vector2 toVector2() {
        return new Vector2((int)this.x, (int)this.y);
    }

    public Vector2f toVector2f() {
        return new Vector2f(this.x, this.y);
    }

    public Vector2d toVector2d() {
        return new Vector2d(this.x, this.y);
    }
}

